% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CJ2.R
\name{CJ2}
\alias{CJ2}
\title{The two-parameter Chris-Jerry distribution family}
\usage{
CJ2(mu.link = "log", sigma.link = "log")
}
\arguments{
\item{mu.link}{defines the mu.link, with "log" link as the default for 
the mu parameter.}

\item{sigma.link}{defines the sigma.link, with "log" link as the default 
for the sigma.}
}
\value{
Returns a gamlss.family object which can be used to fit a CJ2 distribution in the \code{gamlss()} function.
}
\description{
The function \code{CJ2()} defines The  two-parameter  Chris-Jerry distribution, 
a two parameter distribution, for a \code{gamlss.family} object to be used 
in GAMLSS fitting using the function \code{gamlss()}.
}
\details{
The two-parameter  Chris-Jerry distribution with parameters \code{mu} and \code{sigma}
has density given by

\eqn{
f(x; \sigma, \mu) = \frac{\mu^2}{\sigma \mu + 2} (\sigma + \mu x^2) e^{-\mu x}; \quad x > 0, \quad \mu > 0, \quad \sigma > 0
}

Note: In this implementation we changed the original parameters \eqn{\theta} for \eqn{\mu}
and \eqn{\lambda} for \eqn{\sigma} we did it to implement this distribution
within gamlss framework.
}
\examples{
# Example 1
# Generating some random values with
# known mu and sigma
y <- rCJ2(n=500, mu=1, sigma=1.5)

# Fitting the model
require(gamlss)

mod1 <- gamlss(y~1, sigma.fo=~1, family=CJ2,
               control=gamlss.control(n.cyc=5000, trace=TRUE))

# Extracting the fitted values for mu, sigma
# using the inverse link function
exp(coef(mod1, what="mu"))
exp(coef(mod1, what="sigma"))

# Example 2
# Generating random values under some model
gendat <- function(n) {
  x1 <- runif(n, min=0, max=5)
  x2 <- runif(n, min=0, max=5)
  mu <- exp(-0.2 + 1.5 * x1)
  sigma <- exp(1 - 0.7 * x2)
  y <- rCJ2(n=n, mu, sigma)
  data.frame(y=y, x1=x1, x2=x2)
}

set.seed(123)
datos <- gendat(n=500)

mod2 <- gamlss(y~x1, sigma.fo=~x2, family=CJ2, data=datos,
               control=gamlss.control(n.cyc=5000, trace=TRUE))

summary(mod2)
}
\references{
Chinedu, Eberechukwu Q., et al. "New lifetime distribution with applications 
to single acceptance sampling plan and scenarios of increasing hazard 
rates" Symmetry 15.10 (2023): 188.
}
\seealso{
\link{dCJ2}
}
\author{
Manuel Gutierrez Tangarife, \email{mgutierrezta@unal.edu.co}
}
