% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa_utils.R
\name{abs_smooth}
\alias{abs_smooth}
\title{Smooth approximation to the absolute value function}
\usage{
abs_smooth(x, epsilon = 1e-06)
}
\arguments{
\item{x}{vector of evaluation points}

\item{epsilon}{smoothing constant}
}
\value{
Smooth absolute value of \code{x}.
}
\description{
Smooth approximation to the absolute value function
}
\details{
We approximate the absolute value here as
\deqn{\vert x \vert \approx \sqrt{x^2 + \epsilon}}
}
\examples{
abs(0)
abs_smooth(0, 1e-4)
}
