% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Formula.translate.compat.R
\name{Formula.translate.compat}
\alias{Formula.translate.compat}
\title{An internal function, allowing back-compatibility, which translates a model
formula from a formula object or character string into an R list object.}
\usage{
Formula.translate.compat(Formula, levID, D = "Normal", indata)
}
\arguments{
\item{Formula}{A formula object (or a character string) specifying a
multilevel model. See \code{Value} for details.}

\item{levID}{A character (vector) specifying the level ID(s).}

\item{D}{A character string/vector specifying the distribution to be
modelled, which can include \code{'Normal'} (the default), \code{'Binomial'},
\code{'Poisson'}, \code{'Negbinom'}, \code{'Unordered Multinomial'},
\code{'Ordered Multinomial'}, \code{'Multivariate Normal'}, or \code{'Mixed'}.}

\item{indata}{A data.frame object containing the data to be modelled.}
}
\value{
Outputs an R list object, which is then used as the input for
\code{\link{write.IGLS}} and/or \code{\link{write.MCMC}}.
}
\description{
Supports Formula syntax as used in earlier (<0.8-0) versions of \pkg{R2MLwiN}. A model
formula, as a formula object (or a character string) is translated into
an R list object. Called by \code{\link{runMLwiN}} if \code{oldsyntax = TRUE}
(when user specifies \code{levID} not \code{NULL} in \code{\link{runMLwiN}} function
call). For corresponding function supporting new syntax, see
\code{\link{Formula.translate}}.
}
\details{
If \code{Formula} is a character string, then the following
syntax applies:
\itemize{
\item \code{~} A tilde is used to separate response variable(s) and
explanatory variable(s).
\item \code{()} Round brackets are used to specify each random
variable in the model together with its fixed/random part information.
\item \code{|} Separates explanatory variable(s) (placed to the right of
\code{|}) from the fixed/random part information (placed to the left of
\code{|}) when placed within \code{()}.
\item \code{[]} When placed
immediately after an explanatory variable, indicates that the variable is
categorical. The string in the \code{[]} represents the reference category;
if empty, no reference category is used; See note.
\item \code{:} Indicates an interaction term: i.e. the variables adjacent to \code{:}, and
separated by it, are interacted with each other.
\item \code{0} When placed to the left of \code{|} within \code{()} indicates that the variables
to the right of \code{|} within the same \code{()} are to be added to the
fixed part of the model.
\item \code{1} When placed to the left of
\code{|} within \code{()} indicates that the coefficients of the variables
placed to the right of \code{|} within the same \code{()} are to be allowed
to randomly vary at level 1 (and so on for \code{2} for level 2, \code{3} for level 3, etc.)
\item \code{0s/0c} When placed to the left of \code{|} within \code{()}
indicates that separate (hence \code{s}) / common (hence \code{c})
coefficients for the variables to the right of \code{|} within the same
\code{()} are to be added to the fixed part (hence \code{0}) of multivariate
normal, multinomial and mixed responses models.
\item \code{2s/2c} When
placed to the left of \code{|} within \code{()} indicates that separate
(hence \code{s}) / common (hence \code{c}) coefficients for the variables to
the right of \code{|} within the same \code{()} are to be added to the
random part of the model, and allowed to vary at level 2; applies to
multivariate normal, multinomial and mixed responses models only.
\item \code{\{\}} gives a vector of binary indicators specifying a
common coefficient. 1 is to include the component at the corresponding
positions; zero otherwise. These digits are separated by commas; applies to
multivariate normal, multinomial and mixed responses models only.
\item \code{.} Used for adding a separate coefficient for a particular
component at a specific level; applies to multivariate normal, multinomial
and mixed responses models only
}

If \code{Formula} is a formula object, \code{0s/0c}, \code{2s/2c}, .... and
\code{\{\}} have to be replaced by \code{`0s`/`0c`}, \code{`2s`/`2c`}, ....
and \code{()} respectively. Other syntax remains the same.
}
\note{
Note that some characters listed above have special meanings in the
formula, so avoid using them when you name the random variable. Alphanumeric
characters (i.e. \code{[:alnum:]}) are recommended for naming the random
variable. They are also recommended for naming a reference category, inside
\code{[]}.  Note: use \code{[]} notation only in the fixed part when
there is no categorical variable in the random effects. If there is one in
the random part, the categorical variable has to be converted into a set of
binary variables (e.g., using \code{\link{Untoggle}}).
}
\seealso{
\code{\link{runMLwiN}}, \code{\link{write.IGLS}}, \code{\link{write.MCMC}}, \code{\link{Formula.translate}}
}
\author{
Zhang, Z., Charlton, C.M.J., Parker, R.M.A., Leckie, G., and Browne,
W.J. (2016) Centre for Multilevel Modelling, University of Bristol.
}
