% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download.R
\name{retrieve_dgm_measures}
\alias{retrieve_dgm_measures}
\title{Retrieve Pre-Computed Performance measures for a DGM}
\usage{
retrieve_dgm_measures(
  dgm_name,
  measure = NULL,
  method = NULL,
  method_setting = NULL,
  condition_id = NULL,
  replacement = FALSE
)
}
\arguments{
\item{dgm_name}{Character string specifying the DGM type}

\item{measure}{Which performance measure should be returned (e.g., "bias", "mse", "coverage").
All measures can be returned by setting to \code{NULL}.}

\item{method}{Which method(s) should be returned. The complete results are returned by setting to \code{NULL} (default setting).}

\item{method_setting}{Which method setting(s) should be returned. The complete results are returned by setting to \code{NULL} (default setting).}

\item{condition_id}{which conditions should settings be returned for.}

\item{replacement}{Whether performance measures computed using replacement should be returned. Defaults to \code{FALSE}.}
}
\value{
A data.frame
}
\description{
This function returns pre-computed performance measures for a specified
Data-Generating Mechanism (DGM). The pre-computed measures must be already stored
locally. See \code{\link[=download_dgm_measures]{download_dgm_measures()}} function for more guidance.
}
\examples{
\donttest{
  # get bias measures for all methods and conditions
  retrieve_dgm_measures("no_bias", measure = "bias")

  # get all measures for RMA method
  retrieve_dgm_measures("no_bias", method = "RMA")

  # get MSE measures for PET method in condition 1
  retrieve_dgm_measures("no_bias", measure = "mse", method = "PET", condition_id = 1)
}

}
