% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dgm-Bom2019.R
\name{dgm.Bom2019}
\alias{dgm.Bom2019}
\title{Bom and Rachinger (2019) Data-Generating Mechanism}
\usage{
\method{dgm}{Bom2019}(dgm_name, settings)
}
\arguments{
\item{dgm_name}{DGM name (automatically passed)}

\item{settings}{List containing \describe{
\item{mean_effect}{Mean effect}
\item{effect_heterogeneity}{Mean effect heterogeneity}
\item{bias}{Proportion of studies affected by publication bias}
\item{n_studies}{Number of effect size estimates}
\item{sample_sizes}{Sample sizes of the effect size estimates. A vector of
sample sizes needs to be supplied. The sample sizes in the vector are
sequentially reused until all effect size estimates are generated.}
}}
}
\value{
Data frame with \describe{
\item{yi}{effect size}
\item{sei}{standard error}
\item{ni}{sample size}
\item{es_type}{effect size type}
}
}
\description{
Simulates univariate regression environments to estimate the effect of
X1 on Y (parameter alpha1). Effect heterogeneity is introduced via an omitted
variable (X2) correlated with X1, whose coefficient (alpha2)
is randomly distributed with mean zero and variance sigma2_h.

The description and code is based on
\insertCite{hong2021using;textual}{PublicationBiasBenchmark}.
The data-generating mechanism was introduced in
\insertCite{bom2019kinked;textual}{PublicationBiasBenchmark}.
}
\details{
This function simulates univariate regression environments, focusing on
estimating the effect of a variable X1 on a dependent variable Y,
represented by the parameter alpha1. The simulation introduces variation in the
standard errors of estimated effects by allowing sample sizes to differ
across primary studies. Effect heterogeneity is modeled through an omitted
variable (X2) that is correlated with X1, where the coefficient on the
omitted variable, alpha2, is randomly distributed across studies with mean
zero and variance sigma2_h.

Publication selection is modeled in two regimes: (1) no selection, and
(2) 50\% selection. Under 50\% selection, each estimate has a 50\% chance of
being evaluated for inclusion. If selected, only positive and statistically
significant estimates are published; otherwise, new estimates are generated
until this criterion is met. This process continues until the meta-analyst’s
sample reaches its predetermined size.
}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[=dgm]{dgm()}}, \code{\link[=validate_dgm_setting]{validate_dgm_setting()}}
}
