% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_bilateral_indices.R
\name{geowalsh}
\alias{geowalsh}
\title{Calculating the bilateral geometric Walsh price index}
\usage{
geowalsh(data, start, end, interval = FALSE)
}
\arguments{
\item{data}{The user's data frame with information about sold products. It must contain columns: \code{time} (as Date in format: year-month-day,e.g. '2020-12-01'), \code{prices} (as positive numeric), \code{quantities}  (as positive numeric) and \code{prodID} (as numeric, factor or character).}

\item{start}{The base period (as character) limited to the year and month, e.g. "2020-03".}

\item{end}{The research period (as character) limited to the year and month, e.g. "2020-04".}

\item{interval}{A logical value indicating whether the function is to compare the research period defined by \code{end} to the base period defined by \code{start} (then \code{interval} is set to FALSE) or all fixed base indices are to be calculated. In this latter case, all months from the time interval \code{<start,end>} are considered and \code{start} defines the base period (\code{interval} is set to TRUE).}
}
\value{
The function returns a value (or vector of values) of the bilateral geometric Walsh price index depending on the \code{interval} parameter. If the \code{interval} parameter is set to TRUE, the function returns a vector of price index values without dates. To get information about both price index values and corresponding dates, please see functions:  \code{\link{price_indices}} or \code{\link{final_index}}. The function does not take into account aggregating over outlets or product subgroups (to consider these types of aggregating, please use the \code{\link{final_index}} function).
}
\description{
This function returns a value (or vector of values) of the geometric Walsh price index.
}
\examples{
geowalsh(sugar, start="2018-12", end="2019-12")
\donttest{geowalsh(milk, start="2018-12", end="2020-01", interval=TRUE)}
}
\references{
{Walsh, C.M. (1901). \emph{The Measurement of General Exchange Value}. New York: Macmillan and Co., p.202}

{Walsh, C.M. (1921). \emph{The Problem of Estimation}. London: P.S. King & Son, p.97}
}
