% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_data_processing.R
\name{generate_CES}
\alias{generate_CES}
\title{Generating an artificial scanner dataset in the CES model}
\usage{
generate_CES(
  pmi = c(),
  psigma = c(),
  prec = 2,
  elasticity = 0.7,
  S = 1000,
  alfa = c(),
  n = 100,
  n0 = 1,
  r = 1,
  r0 = 1,
  start,
  days = FALSE
)
}
\arguments{
\item{pmi}{A numeric vector indicating \code{mi} parameters for lognormally distributed prices from the subsequent months.}

\item{psigma}{A numeric vector indicating \code{sigma} parameters for lognormally distributed prices from the subsequent months.}

\item{prec}{A numeric value indicating precision, i.e. the number of decimal places, for generating prices.}

\item{elasticity}{The elasticity of substitution. The default value is 0.7.}

\item{S}{Sum of spending. The default value is 1000.}

\item{alfa}{A numeric vector indicating positive weights that reflect the consumer preferences.By default, this vector is randomized based on a uniform distribution.}

\item{n}{An integer parameter indicating the number of products which are to be generated.}

\item{n0}{An integer parameter indicating the first (the smallest) prodID.}

\item{r}{An integer parameter indicating the number of outlets (retailer sale points) for which prices and quantities are to be generated.}

\item{r0}{n0 An integer parameter indicating the first (the smallest) retID.}

\item{start}{The first period in the generated data frame (as character) limited to the year and month, e.g. '2019-12'.}

\item{days}{A logical parameter indicating whether the trading day in a given month is to be randomised. The default value of \code{days} is FALSE, which means that each transaction for a given month takes place on the first day of the month.}
}
\value{
This function returns an artificial scanner dataset where prices are lognormally distributed, quantities are calculated under the assumption that consumers have CES (Constant Elasticity of Substitution) preferences and their spending on all products is \code{S}. The characteristics for the lognormal price distribution are set by \code{pmi} and \code{psigma} parameters. This function works for a fixed number of products and outlets (see \code{n} and \code{r} parameters). The generated dataset is ready for further price index calculations.
}
\description{
This function provides artificial scanner datasets where prices are lognormally distributed and quantities are obtained under a CES utility.
}
\examples{
#Generating an artificial dataset (the elasticity of substitution is 1.25)
\donttest{df<-generate_CES(pmi=c(1.02,1.03),psigma=c(0.04,0.03),
elasticity=1.25,start="2020-01",n=100,days=TRUE)}
#Verifying the elasticity of substitution
\donttest{elasticity(df, start="2020-01",end="2020-02")}
}
\references{
{(2004). \emph{Consumer Price Index Manual. Theory and practice}. ILO/IMF/OECD/UNECE/Eurostat/The World Bank, International Labour Office (ILO), Geneva.}
}
