% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/databaseDiagnostics.R
\name{databaseDiagnostics}
\alias{databaseDiagnostics}
\title{Database diagnostics}
\usage{
databaseDiagnostics(cohort)
}
\arguments{
\item{cohort}{Cohort table in a cdm reference}
}
\value{
A summarised result
}
\description{
phenotypeR diagnostics on the cdm object.

Diagnostics include:
* Summarise a cdm_reference object, creating a snapshot with the metadata of the cdm_reference object.
* Summarise the observation period table getting some overall statistics in a summarised_result object.
* Summarise the person table including demographics (sex, race, ethnicity, year of birth) and related statistics.
}
\examples{
\donttest{
library(omock)
library(PhenotypeR)
library(CohortConstructor)

cdm <- mockCdmFromDataset(source = "duckdb")

cdm$new_cohort <- conceptCohort(cdm,
                                conceptSet = list("codes" = c(40213201L, 4336464L)),
                                name = "new_cohort")

}
}
