% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addDemographicsQuery.R
\name{addDateOfBirthQuery}
\alias{addDateOfBirthQuery}
\title{Query to add a column with the individual birth date}
\usage{
addDateOfBirthQuery(
  x,
  dateOfBirthName = "date_of_birth",
  missingDay = 1,
  missingMonth = 1,
  imposeDay = FALSE,
  imposeMonth = FALSE
)
}
\arguments{
\item{x}{Table with individuals in the cdm.}

\item{dateOfBirthName}{dateOfBirth column name.}

\item{missingDay}{day of the month assigned to individuals
with missing day of birth.}

\item{missingMonth}{Month of the year assigned to individuals with missing
month of birth.}

\item{imposeDay}{TRUE or FALSE. Whether the day of the date of birth
will be considered as missing for all the individuals.}

\item{imposeMonth}{TRUE or FALSE. Whether the month of the date of birth
will be considered as missing for all the individuals.}
}
\value{
The function returns the table x with an extra column that contains
the date of birth.
}
\description{
Same as \code{addDateOfBirth()}, except query is not computed to a table.
}
\examples{
\donttest{
library(PatientProfiles)

cdm <- mockPatientProfiles(source = "duckdb")

cdm$cohort1 |>
  addDateOfBirthQuery()

}
}
