% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addCohortIntersect.R
\name{addCohortIntersectField}
\alias{addCohortIntersectField}
\title{It creates a column with the field of a desired intersection}
\usage{
addCohortIntersectField(
  x,
  targetCohortTable,
  field,
  targetCohortId = NULL,
  indexDate = "cohort_start_date",
  censorDate = NULL,
  targetDate = "cohort_start_date",
  order = "first",
  window = list(c(0, Inf)),
  nameStyle = "{cohort_name}_{field}_{window_name}",
  name = NULL
)
}
\arguments{
\item{x}{Table with individuals in the cdm.}

\item{targetCohortTable}{name of the cohort that we want to check for overlap.}

\item{field}{Column of interest in the targetCohort.}

\item{targetCohortId}{vector of cohort definition ids to include.}

\item{indexDate}{Variable in x that contains the date to compute the
intersection.}

\item{censorDate}{whether to censor overlap events at a specific date
or a column date of x.}

\item{targetDate}{Date of interest in the other cohort table. Either
cohort_start_date or cohort_end_date.}

\item{order}{date to use if there are multiple records for an
individual during the window of interest. Either first or last.}

\item{window}{Window of time to identify records relative to the indexDate.
Records outside of this time period will be ignored.}

\item{nameStyle}{naming of the added column or columns, should include
required parameters.}

\item{name}{Name of the new table, if NULL a temporary table is returned.}
}
\value{
table with added columns with overlap information.
}
\description{
It creates a column with the field of a desired intersection
}
\examples{
\donttest{
library(PatientProfiles)
library(dplyr)

cdm <- mockPatientProfiles(source = "duckdb")

cdm$cohort2 <- cdm$cohort2 |>
  mutate(even = if_else(subject_id \%\% 2, "yes", "no")) |>
  compute(name = "cohort2")

cdm$cohort1 |>
  addCohortIntersectFlag(
    targetCohortTable = "cohort2"
  )

}

}
