% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addConceptIntersect.R
\name{addConceptIntersectFlag}
\alias{addConceptIntersectFlag}
\title{It creates column to indicate the flag overlap information between a table
and a concept}
\usage{
addConceptIntersectFlag(
  x,
  conceptSet,
  indexDate = "cohort_start_date",
  censorDate = NULL,
  window = list(c(0, Inf)),
  targetStartDate = "event_start_date",
  targetEndDate = "event_end_date",
  inObservation = TRUE,
  nameStyle = "{concept_name}_{window_name}",
  name = NULL
)
}
\arguments{
\item{x}{Table with individuals in the cdm.}

\item{conceptSet}{Concept set list.}

\item{indexDate}{Variable in x that contains the date to compute the
intersection.}

\item{censorDate}{whether to censor overlap events at a date column of x}

\item{window}{window to consider events in.}

\item{targetStartDate}{Event start date to use for the intersection.}

\item{targetEndDate}{Event end date to use for the intersection.}

\item{inObservation}{If TRUE only records inside an observation period
will be considered.}

\item{nameStyle}{naming of the added column or columns, should include
required parameters.}

\item{name}{Name of the new table, if NULL a temporary table is returned.}
}
\value{
table with added columns with overlap information
}
\description{
It creates column to indicate the flag overlap information between a table
and a concept
}
\examples{
\donttest{
library(PatientProfiles)
library(omopgenerics, warn.conflicts = TRUE)
library(dplyr, warn.conflicts = TRUE)

cdm <- mockPatientProfiles(source = "duckdb")

concept <- tibble(
  concept_id = c(1125315),
  domain_id = "Drug",
  vocabulary_id = NA_character_,
  concept_class_id = "Ingredient",
  standard_concept = "S",
  concept_code = NA_character_,
  valid_start_date = as.Date("1900-01-01"),
  valid_end_date = as.Date("2099-01-01"),
  invalid_reason = NA_character_
) |>
  mutate(concept_name = paste0("concept: ", .data$concept_id))
cdm <- insertTable(cdm, "concept", concept)

cdm$cohort1 |>
  addConceptIntersectFlag(conceptSet = list("acetaminophen" = 1125315))

}

}
