\name{fit_HPTL}
\alias{fit_HPTL}
\title{HPTL (Heterogeneous Partial Transfer Learning) Fit}
\description{
  Fits heterogeneous partial transfer learning with multiple sources and
  covariate modules. Each source has its own module of covariates; PTL is
  applied per source and results are combined for the target causal estimate.
}
\usage{
fit_HPTL(D_t, X_t, Y_t, D_s_all, X_s_all, Y_s_all, source_sizes, module_sizes,
         ml_f, ml_g, fold = 5)
}
\arguments{
  \item{D_t}{Target treatment; \eqn{n_t \times q} matrix.}
  \item{X_t}{Target design matrix; \eqn{n_t \times p} (same covariates as sources).}
  \item{Y_t}{Target outcome; \eqn{n_t \times 1}.}
  \item{D_s_all}{Source treatments concatenated by row; dimension is (sum of \code{source_sizes}) by \eqn{q}.}
  \item{X_s_all}{Source design matrices concatenated by row; rows split by \code{source_sizes}.}
  \item{Y_s_all}{Source outcomes concatenated by row; rows split by \code{source_sizes}.}
  \item{source_sizes}{Integer vector of length K: sample size of each source. Must sum to \code{nrow(Y_s_all)}.}
  \item{module_sizes}{Integer vector of length K: covariate module sizes. The k-th source uses columns \code{(cumsum(module_sizes)[k-1]+1):cumsum(module_sizes)[k]} of X.}
  \item{ml_f}{Outcome learner for DoubleML.}
  \item{ml_g}{Treatment learner for DoubleML.}
  \item{fold}{Number of folds for cross-fitting (default 5).}
}
\value{
  A list with component \code{hat_rho_HPTL}: HPTL causal estimate on target.
}
\seealso{
  \code{\link{fit_PTL}}, \code{\link{boot_detection}}
}
