% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/A03-bootstrap-variance.R
\name{generate_boot_indices}
\alias{generate_boot_indices}
\title{Generate Bootstrap Sample Indices}
\usage{
generate_boot_indices(data, treatment_var, boot_level = "full")
}
\arguments{
\item{data}{Data frame to bootstrap from.}

\item{treatment_var}{Name of treatment variable.}

\item{boot_level}{Bootstrap sampling level: "full" (default) samples from
entire dataset, "strata" samples within each treatment group preserving
group sizes.}
}
\value{
Integer vector of bootstrap indices of length \code{nrow(data)}.
}
\description{
Helper function to generate bootstrap sample indices for either full sample
resampling (observational studies) or stratified resampling within treatment
groups (randomized controlled trials with fixed allocation).
}
\keyword{internal}
