% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCM.R
\name{PCMMean}
\alias{PCMMean}
\title{Expected mean vector at each tip conditioned on a trait-value vector at the root}
\usage{
PCMMean(
  tree,
  model,
  X0 = model$X0,
  metaI = PCMInfo(NULL, tree, model, verbose = verbose),
  internal = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{tree}{a phylo object with N tips.}

\item{model}{an S3 object specifying both, the model type (class, e.g. "OU") as
well as the concrete model parameter values at which the likelihood is to be
calculated (see also Details).}

\item{X0}{a k-vector denoting the root trait}

\item{metaI}{a list returned from a call to \code{PCMInfo(X, tree, model, SE)},
containing meta-data such as N, M and k. Alternatively, this can be a
character string naming a function or a function object that returns such
a list, e.g. the function\code{PCMInfo} or the function \code{PCMInfoCpp}
from the \code{PCMBaseCpp} package.}

\item{internal}{a logical indicating ig the per-node mean vectors should be returned (see Value). Default FALSE.}

\item{verbose}{logical indicating if some debug-messages should printed.}
}
\value{
If internal is FALSE (default), then a k x N matrix Mu, such that \code{Mu[, i]} equals the expected mean k-vector
at tip i, conditioned on \code{X0} and the tree. Otherwise, a k x M matrix Mu containing the mean vector for each node.
}
\description{
Expected mean vector at each tip conditioned on a trait-value vector at the root
}
\examples{
# a Brownian motion model with one regime
modelBM <- PCM(model = "BM", k = 2)
# print the model
modelBM
# assign the model parameters at random: this will use uniform distribution
# with boundaries specified by PCMParamLowerLimit and PCMParamUpperLimit
# We do this in two steps:
# 1. First we generate a random vector. Note the length of the vector equals PCMParamCount(modelBM)
randomParams <- PCMParamRandomVecParams(modelBM, PCMNumTraits(modelBM), PCMNumRegimes(modelBM))
randomParams
# 2. Then we load this random vector into the model.
PCMParamLoadOrStore(modelBM, randomParams, 0, PCMNumTraits(modelBM), PCMNumRegimes(modelBM), TRUE)

# create a random tree of 10 tips
tree <- ape::rtree(10)
PCMMean(tree, modelBM)
}
