% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{network_propagation}
\alias{network_propagation}
\title{Network Propagation (Random-walk with Restart)}
\usage{
network_propagation(prior_vec, W_prime, alpha, max.iter = 1000, eps = 1e-04)
}
\arguments{
\item{prior_vec}{vector of prior knowledge on selected genes (names are gene symbols)}

\item{W_prime}{(Laplacian-normalized, symmetric) adjacency matrix}

\item{alpha}{restart parameter, controlling trade-off between prior information and network smoothing}

\item{max.iter}{maximum allowed number of iterations (default = 1000)}

\item{eps}{epsilon value to assess the L2 norm of the difference between iterations (default = 1e-4)}
}
\value{
vector of propagation values
}
\description{
Network Propagation (Random-walk with Restart)
}
\details{
Implementing RWR following the following publications:
Cowen L, Ideker T, Raphael BJ, Sharan R. Network propagation: a universal amplifier of genetic associations. Nat Rev Genet. 2017 Sep;18(9):551–62.
Shnaps O, Perry E, Silverbush D, Sharan R. Inference of personalized drug targets via network propagation. Pac Symp Biocomput. 2016;21:156–67.
}
