% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Compass.r
\name{opiSetup_for_Compass}
\alias{opiSetup_for_Compass}
\title{Implementation of opiSetup for the Compass machine.}
\arguments{
\item{settings}{is a list that could contain:
\itemize{
\item \code{fixation} \code{c(x,y,t)} where
\itemize{
\item \code{x} is one of -20, -6, -3, 0, 3, 6, 20 degrees.
\item \code{y} is 0 degrees.
\item \code{t} is 0 for a spot fixation marker at \code{c(x,y)}, or 1 for a
square centred on one of \code{(-3,0)}, \code{(0,0)}, \code{(+3,0)}.
}
\item \code{tracking_on} \code{TRUE} for tracking on, \code{FALSE} for off
}}
}
\value{
A list containing \code{err} which is \code{NULL} for success, or some string description for fail.
}
\description{
This is for internal use only. Use \code{\link[=opiSetup]{opiSetup()}} with
these Arguments and you will get the Value back.
}
\details{
Note: tracking will be relative to the PRL established with the fixation
marker used at setup (call to OPI-OPEN), so when tracking is on you should
use the same fixation location as in the setup.
}
