% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dy_dx.R
\name{dy.dx}
\alias{dy.dx}
\title{Partial Derivative dy/dx}
\usage{
dy.dx(x, y, eval.point = NULL)
}
\arguments{
\item{x}{a numeric vector.}

\item{y}{a numeric vector.}

\item{eval.point}{numeric or ("overall"); \code{x} point to be evaluated, must be provided.  Defaults to \code{(eval.point = NULL)}.  Set to \code{(eval.point = "overall")} to find an overall partial derivative estimate (1st derivative only).}
}
\value{
Returns a \code{data.table} of eval.point along with both 1st and 2nd derivative.
}
\description{
Returns the numerical partial derivative of \code{y} wrt \code{x} for a point of interest.
}
\examples{
\dontrun{
x <- seq(0, 2 * pi, pi / 100) ; y <- sin(x)
dy.dx(x, y, eval.point = 1.75)

# First derivative
dy.dx(x, y, eval.point = 1.75)[ , first.derivative]

# Second derivative
dy.dx(x, y, eval.point = 1.75)[ , second.derivative]

# Vector of derivatives
dy.dx(x, y, eval.point = c(1.75, 2.5))
}
}
\references{
Viole, F. and Nawrocki, D. (2013) "Nonlinear Nonparametric Statistics: Using Partial Moments" (ISBN: 1490523995)

Vinod, H. and Viole, F. (2017) "Nonparametric Regression Using Clusters"  \doi{10.1007/s10614-017-9713-5}
}
\author{
Fred Viole, OVVO Financial Systems
}
