Mon 10/22/2018 
01:15 PM
; Used for comparing single versus parallel computing for FOCE method.
$PROB RUN# Example 1 (from samp5l)
$INPUT C SET ID JID TIME  DV=CONC AMT=DOSE RATE EVID MDV CMT CLX V1X QX V2X SDIX SDSX
$DATA example1.csv IGNORE=C

$SUBROUTINES ADVAN3 TRANS4

$PK
MU_1=THETA(1)
MU_2=THETA(2)
MU_3=THETA(3)
MU_4=THETA(4)
CL=DEXP(MU_1+ETA(1))
V1=DEXP(MU_2+ETA(2))
Q=DEXP(MU_3+ETA(3))
V2=DEXP(MU_4+ETA(4))
S1=V1

LCL=LOG(CL)
LV1=LOG(V1)
LQ=LOG(Q)
LV2=LOG(V2)
RECNO=NDREC

$ERROR
IPRED=F
If(COMACT==1) PREDU=IPRED
Y = IPRED + IPRED*EPS(1)

; Initial values of THETA
$THETA 2 2 2 2
;INITIAL values of OMEGA
$OMEGA BLOCK(4)
0.15   ;[P]
0.01  ;[F]
0.15   ;[P]
0.01  ;[F]
0.01  ;[F]
0.15   ;[P]
0.01  ;[F]
0.01  ;[F]
0.01  ;[F]
0.15   ;[P]
;Initial value of SIGMA
$SIGMA 
(0.6 )   ;[P]

$EST METHOD=1 INTERACTION NSIG=3 PRINT=1 NOABORT  MAXEVAL=9999 SIGL=10 FAST
$COV MATRIX=R PRINT=E UNCONDITIONAL 
$TABLE ID RECNO TIME IPRED PREDU PRED VARCALC=3 NOAPPEND NOPRINT FILE=predu.tab
  
NM-TRAN MESSAGES 
  
 WARNINGS AND ERRORS (IF ANY) FOR PROBLEM    1
             
 (WARNING  2) NM-TRAN INFERS THAT THE DATA ARE POPULATION.
  
License Registered to: IDS NONMEM 7 TEAM
Expiration Date:     2 JUN 2030
Current Date:       22 OCT 2018
Days until program expires :4240
1NONLINEAR MIXED EFFECTS MODEL PROGRAM (NONMEM) VERSION 7.5.0 alpha version 4
 ORIGINALLY DEVELOPED BY STUART BEAL, LEWIS SHEINER, AND ALISON BOECKMANN
 CURRENT DEVELOPERS ARE ROBERT BAUER, ICON DEVELOPMENT SOLUTIONS,
 AND ALISON BOECKMANN. IMPLEMENTATION, EFFICIENCY, AND STANDARDIZATION
 PERFORMED BY NOUS INFOSYSTEMS.

 PROBLEM NO.:         1
 RUN# Example 1 (from samp5l)
0DATA CHECKOUT RUN:              NO
 DATA SET LOCATED ON UNIT NO.:    2
 THIS UNIT TO BE REWOUND:        NO
 NO. OF DATA RECS IN DATA SET:      600
 NO. OF DATA ITEMS IN DATA SET:  17
 ID DATA ITEM IS DATA ITEM NO.:   3
 DEP VARIABLE IS DATA ITEM NO.:   6
 MDV DATA ITEM IS DATA ITEM NO.: 10
0INDICES PASSED TO SUBROUTINE PRED:
   9   5   7   8   0   0  11   0   0   0   0
0LABELS FOR DATA ITEMS:
 C SET ID JID TIME CONC DOSE RATE EVID MDV CMT CLX V1X QX V2X SDIX SDSX
0(NONBLANK) LABELS FOR PRED-DEFINED ITEMS:
 PREDU RECNO IPRED
0FORMAT FOR DATA:
 (2E2.0,3E4.0,E11.0,E4.0,4E2.0,2E7.0,E8.0,E7.0,E2.0,E5.0)

 TOT. NO. OF OBS RECS:      500
 TOT. NO. OF INDIVIDUALS:      100
0LENGTH OF THETA:   4
0DEFAULT THETA BOUNDARY TEST OMITTED:    NO
0OMEGA HAS BLOCK FORM:
  1
  1  1
  1  1  1
  1  1  1  1
0DEFAULT OMEGA BOUNDARY TEST OMITTED:    NO
0SIGMA HAS SIMPLE DIAGONAL FORM WITH DIMENSION:   1
0DEFAULT SIGMA BOUNDARY TEST OMITTED:    NO
0INITIAL ESTIMATE OF THETA:
   0.2000E+01  0.2000E+01  0.2000E+01  0.2000E+01
0INITIAL ESTIMATE OF OMEGA:
 BLOCK SET NO.   BLOCK                                                                    FIXED
        1                                                                                   NO
                  0.1500E+00
                  0.1000E-01   0.1500E+00
                  0.1000E-01   0.1000E-01   0.1500E+00
                  0.1000E-01   0.1000E-01   0.1000E-01   0.1500E+00
0INITIAL ESTIMATE OF SIGMA:
 0.6000E+00
0COVARIANCE STEP OMITTED:        NO
 R MATRIX SUBSTITUTED:          YES
 S MATRIX SUBSTITUTED:           NO
 EIGENVLS. PRINTED:             YES
 COMPRESSED FORMAT:              NO
 GRADIENT METHOD USED:       FAST
 SIGDIGITS ETAHAT (SIGLO):                  -1
 SIGDIGITS GRADIENTS (SIGL):                -1
 EXCLUDE COV FOR FOCE (NOFCOV):              NO
 TURN OFF Cholesky Transposition of R Matrix (CHOLROFF): NO
 KNUTHSUMOFF:                                -1
 RESUME COV ANALYSIS (RESUME):               NO
 SIR SAMPLE SIZE (SIRSAMPLE):              -1
 NON-LINEARLY TRANSFORM THETAS DURING COV (THBND): 1
 PRECONDTIONING CYCLES (PRECOND):        0
 PRECONDTIONING TYPES (PRECONDS):        TOS
 FORCED PRECONDTIONING CYCLES (PFCOND):0
 PRECONDTIONING TYPE (PRETYPE):        0
 FORCED POS. DEFINITE SETTING: (FPOSDEF):0
0TABLES STEP OMITTED:    NO
 NO. OF TABLES:           1
 SEED NUMBER (SEED):    11456
 RANMETHOD:             3U
 MC SAMPLES (ESAMPLE):    300
 WRES SQUARE ROOT TYPE (WRESCHOL): EIGENVALUE
0-- TABLE   1 --
0RECORDS ONLY:    ALL
04 COLUMNS APPENDED:    NO
 PRINTED:                NO
 HEADER:                YES
 FILE TO BE FORWARDED:   NO
 FORMAT:                S1PE11.4
 IDFORMAT:
 LFORMAT:
 RFORMAT:
 FIXED_EFFECT_ETAS:
0USER-CHOSEN ITEMS:
 ID RECNO TIME IPRED PREDU PRED
1DOUBLE PRECISION PREDPP VERSION 7.5.0 alpha version 4

 TWO COMPARTMENT MODEL (ADVAN3)
0MAXIMUM NO. OF BASIC PK PARAMETERS:   4
0BASIC PK PARAMETERS (AFTER TRANSLATION):
   BASIC PK PARAMETER NO.  1: ELIMINATION RATE (K)
   BASIC PK PARAMETER NO.  2: CENTRAL-TO-PERIPH. RATE (K12)
   BASIC PK PARAMETER NO.  3: PERIPH.-TO-CENTRAL RATE (K21)
 TRANSLATOR WILL CONVERT PARAMETERS
 CL, V1, Q, V2 TO K, K12, K21 (TRANS4)
0COMPARTMENT ATTRIBUTES
 COMPT. NO.   FUNCTION   INITIAL    ON/OFF      DOSE      DEFAULT    DEFAULT
                         STATUS     ALLOWED    ALLOWED    FOR DOSE   FOR OBS.
    1         CENTRAL      ON         NO         YES        YES        YES
    2         PERIPH.      ON         NO         YES        NO         NO
    3         OUTPUT       OFF        YES        NO         NO         NO
1
 ADDITIONAL PK PARAMETERS - ASSIGNMENT OF ROWS IN GG
 COMPT. NO.                             INDICES
              SCALE      BIOAVAIL.   ZERO-ORDER  ZERO-ORDER  ABSORB
                         FRACTION    RATE        DURATION    LAG
    1            5           *           *           *           *
    2            *           *           *           *           *
    3            *           -           -           -           -
             - PARAMETER IS NOT ALLOWED FOR THIS MODEL
             * PARAMETER IS NOT SUPPLIED BY PK SUBROUTINE;
               WILL DEFAULT TO ONE IF APPLICABLE
0DATA ITEM INDICES USED BY PRED ARE:
   EVENT ID DATA ITEM IS DATA ITEM NO.:      9
   TIME DATA ITEM IS DATA ITEM NO.:          5
   DOSE AMOUNT DATA ITEM IS DATA ITEM NO.:   7
   DOSE RATE DATA ITEM IS DATA ITEM NO.:     8
   COMPT. NO. DATA ITEM IS DATA ITEM NO.:   11

0PK SUBROUTINE CALLED WITH EVERY EVENT RECORD.
 PK SUBROUTINE NOT CALLED AT NONEVENT (ADDITIONAL OR LAGGED) DOSE TIMES.
0ERROR SUBROUTINE CALLED WITH EVERY EVENT RECORD.
1
 
 
 #TBLN:      1
 #METH: First Order Conditional Estimation with Interaction
 
 ESTIMATION STEP OMITTED:                 NO
 ANALYSIS TYPE:                           POPULATION
 NUMBER OF SADDLE POINT RESET ITERATIONS:      0
 GRADIENT METHOD USED:               FAST
 CONDITIONAL ESTIMATES USED:              YES
 CENTERED ETA:                            NO
 EPS-ETA INTERACTION:                     YES
 LAPLACIAN OBJ. FUNC.:                    NO
 NO. OF FUNCT. EVALS. ALLOWED:            9999
 NO. OF SIG. FIGURES REQUIRED:            3
 INTERMEDIATE PRINTOUT:                   YES
 ESTIMATE OUTPUT TO MSF:                  NO
 ABORT WITH PRED EXIT CODE 1:             NO
 IND. OBJ. FUNC. VALUES SORTED:           NO
 NUMERICAL DERIVATIVE
       FILE REQUEST (NUMDER):               NONE
 MAP (ETAHAT) ESTIMATION METHOD (OPTMAP):   0
 ETA HESSIAN EVALUATION METHOD (ETADER):    0
 INITIAL ETA FOR MAP ESTIMATION (MCETA):    0
 SIGDIGITS FOR MAP ESTIMATION (SIGLO):      10
 GRADIENT SIGDIGITS OF
       FIXED EFFECTS PARAMETERS (SIGL):     10
 NOPRIOR SETTING (NOPRIOR):                 OFF
 NOCOV SETTING (NOCOV):                     OFF
 DERCONT SETTING (DERCONT):                 OFF
 FINAL ETA RE-EVALUATION (FNLETA):          ON
 EXCLUDE NON-INFLUENTIAL (NON-INFL.) ETAS
       IN SHRINKAGE (ETASTYPE):             NO
 NON-INFL. ETA CORRECTION (NONINFETA):      OFF
 RAW OUTPUT FILE (FILE): predu.ext
 EXCLUDE TITLE (NOTITLE):                   NO
 EXCLUDE COLUMN LABELS (NOLABEL):           NO
 FORMAT FOR ADDITIONAL FILES (FORMAT):      S1PE12.5
 PARAMETER ORDER FOR OUTPUTS (ORDER):       TSOL
 WISHART PRIOR DF INTERPRETATION (WISHTYPE):0
 KNUTHSUMOFF:                               0
 INCLUDE LNTWOPI:                           NO
 INCLUDE CONSTANT TERM TO PRIOR (PRIORC):   NO
 INCLUDE CONSTANT TERM TO OMEGA (ETA) (OLNTWOPI):NO
 ADDITIONAL CONVERGENCE TEST (CTYPE=4)?:    NO
 EM OR BAYESIAN METHOD USED:                 NONE

 
 THE FOLLOWING LABELS ARE EQUIVALENT
 PRED=PREDI
 RES=RESI
 WRES=WRESI
 IWRS=IWRESI
 IPRD=IPREDI
 IRS=IRESI
 
 MONITORING OF SEARCH:

 
0ITERATION NO.:    0    OBJECTIVE VALUE:  -234.362902809730        NO. OF FUNC. EVALS.:   2
 CUMULATIVE NO. OF FUNC. EVALS.:        2
 NPARAMETR:  2.0000E+00  2.0000E+00  2.0000E+00  2.0000E+00  1.5000E-01  1.0000E-02  1.0000E-02  1.0000E-02  1.5000E-01  1.0000E-02
             1.0000E-02  1.5000E-01  1.0000E-02  1.5000E-01  6.0000E-01
 PARAMETER:  1.0000E-01  1.0000E-01  1.0000E-01  1.0000E-01  1.0000E-01  1.0000E-01  1.0000E-01  1.0000E-01  1.0000E-01  1.0000E-01
             1.0000E-01  1.0000E-01  1.0000E-01  1.0000E-01  1.0000E-01
 GRADIENT:   6.3395E+03 -1.0532E+02  8.9651E+03 -1.7061E+04 -8.7017E+01  1.0160E+01 -4.4639E+01  1.1044E+02  1.3003E+01 -6.6558E+00
            -1.0328E+00 -1.2937E+02  1.4888E+02 -5.1162E+02  3.4890E+02
 
0ITERATION NO.:    1    OBJECTIVE VALUE:  -378.492492341776        NO. OF FUNC. EVALS.:   4
 CUMULATIVE NO. OF FUNC. EVALS.:        6
 NPARAMETR:  1.4426E+00  2.0093E+00  1.2118E+00  3.5000E+00  1.5011E-01  9.9994E-03  1.0023E-02  9.9553E-03  1.4998E-01  1.0003E-02
             9.9964E-03  1.5017E-01  9.9459E-03  1.5066E-01  5.9816E-01
 PARAMETER:  7.2132E-02  1.0046E-01  6.0590E-02  1.7500E-01  1.0038E-01  9.9955E-02  1.0020E-01  9.9515E-02  9.9943E-02  1.0003E-01
             1.0000E-01  1.0057E-01  9.9346E-02  1.0225E-01  9.8466E-02
 GRADIENT:  -1.2827E+04  1.9759E+03 -3.2460E+03  1.0109E+04 -3.0585E+02  3.9161E+01 -8.6805E+01  1.9540E+02  1.6668E+01  2.0997E+01
            -4.8133E+01 -3.5117E+01  7.4736E+01 -3.0651E+02  4.4598E+02
 
0ITERATION NO.:    2    OBJECTIVE VALUE:  -590.264933440702        NO. OF FUNC. EVALS.:   4
 CUMULATIVE NO. OF FUNC. EVALS.:       10
 NPARAMETR:  2.5246E+00  1.8426E+00  1.4856E+00  2.6473E+00  1.5050E-01  9.9957E-03  1.0073E-02  9.8856E-03  1.4996E-01  9.9956E-03
             1.0008E-02  1.5022E-01  9.9172E-03  1.5103E-01  5.9592E-01
 PARAMETER:  1.2623E-01  9.2130E-02  7.4280E-02  1.3236E-01  1.0167E-01  9.9790E-02  1.0056E-01  9.8690E-02  9.9873E-02  9.9941E-02
             1.0021E-01  1.0072E-01  9.9030E-02  1.0354E-01  9.6585E-02
 GRADIENT:   1.2570E+04 -2.1632E+03  2.8614E+03 -5.7955E+03 -3.0451E+02  3.4994E+01 -4.5465E+01  9.9811E+01  1.6627E+01  6.0205E+00
            -1.8644E+01  2.6854E+00  9.4985E+00 -3.4563E+01  2.3798E+02
 
0ITERATION NO.:    3    OBJECTIVE VALUE:  -591.086823021663        NO. OF FUNC. EVALS.:   5
 CUMULATIVE NO. OF FUNC. EVALS.:       15
 NPARAMETR:  2.4069E+00  1.8768E+00  1.4785E+00  2.4487E+00  1.5111E-01  9.9914E-03  1.0136E-02  9.8108E-03  1.4992E-01  9.9879E-03
             1.0019E-02  1.5025E-01  9.8925E-03  1.5133E-01  5.9332E-01
 PARAMETER:  1.2034E-01  9.3841E-02  7.3923E-02  1.2244E-01  1.0367E-01  9.9548E-02  1.0099E-01  9.7748E-02  9.9763E-02  9.9856E-02
             1.0042E-01  1.0081E-01  9.8771E-02  1.0459E-01  9.4398E-02
 GRADIENT:   1.0539E+04 -1.3176E+03  4.5550E+03 -8.8436E+03 -2.1623E+02  2.0377E+01 -5.7625E+01  1.2357E+02  2.2319E+01  5.1081E+00
            -1.7700E+01 -1.5206E+01  3.1552E+01 -1.1530E+02  3.0177E+02
 
0ITERATION NO.:    4    OBJECTIVE VALUE:  -599.978568258317        NO. OF FUNC. EVALS.:   4
 CUMULATIVE NO. OF FUNC. EVALS.:       19
 NPARAMETR:  2.3824E+00  1.8542E+00  1.2567E+00  2.3334E+00  1.5241E-01  9.9845E-03  1.0290E-02  9.6081E-03  1.4983E-01  9.9704E-03
             1.0044E-02  1.5037E-01  9.8210E-03  1.5221E-01  5.8660E-01
 PARAMETER:  1.1912E-01  9.2709E-02  6.2834E-02  1.1667E-01  1.0798E-01  9.9051E-02  1.0208E-01  9.5317E-02  9.9464E-02  9.9656E-02
             1.0092E-01  1.0116E-01  9.8008E-02  1.0762E-01  8.8705E-02
 GRADIENT:   1.0671E+04 -1.4924E+03  3.5376E+03 -8.7588E+03 -2.2032E+02  2.4483E+01 -4.6188E+01  1.2703E+02  2.2318E+01  4.8255E+00
            -1.9940E+01  1.7173E+00  2.0862E+01 -1.1543E+02  3.2838E+02
 
0ITERATION NO.:    5    OBJECTIVE VALUE:  -893.530309062727        NO. OF FUNC. EVALS.:   3
 CUMULATIVE NO. OF FUNC. EVALS.:       22
 NPARAMETR:  2.0905E+00  1.6148E+00  9.4482E-01  2.0828E+00  3.1299E-01  7.7775E-03  2.6637E-02 -1.7558E-02  1.4161E-01  8.2057E-03
             1.2907E-02  1.5527E-01  2.9398E-03  2.6260E-01  2.0233E-01
 PARAMETER:  1.0453E-01  8.0740E-02  4.7241E-02  1.0414E-01  4.6776E-01  5.3842E-02  1.8440E-01 -1.2155E-01  7.2770E-02  8.3058E-02
             1.4691E-01  1.1279E-01  4.2000E-02  3.8146E-01 -4.4353E-01
 GRADIENT:   3.7881E+03 -1.4287E+03  1.8127E+03 -4.8639E+03  2.4785E+01  1.1838E+01 -1.2539E+01  3.3503E+01  2.5165E+01  1.4824E+00
            -9.2324E+00  2.1079E+01 -3.6986E-01 -1.5385E-01  3.2818E+02
 
0ITERATION NO.:    6    OBJECTIVE VALUE:  -900.196746545498        NO. OF FUNC. EVALS.:   5
 CUMULATIVE NO. OF FUNC. EVALS.:       27
 NPARAMETR:  2.1309E+00  1.8632E+00  8.8673E-01  2.0782E+00  3.2722E-01  7.5083E-03  2.8015E-02 -1.9980E-02  1.4105E-01  8.0743E-03
             1.3131E-02  1.5555E-01  2.4211E-03  2.7178E-01  1.8800E-01
 PARAMETER:  1.0655E-01  9.3162E-02  4.4336E-02  1.0391E-01  4.9000E-01  5.0836E-02  1.8968E-01 -1.3528E-01  7.0850E-02  8.1978E-02
             1.4991E-01  1.1330E-01  3.8512E-02  3.9828E-01 -4.8025E-01
 GRADIENT:   3.8237E+03  1.5975E+03  1.3663E+03 -4.6253E+03  2.2217E+01 -1.4321E+01 -1.2825E+01  3.2468E+01  2.2968E+01 -4.9791E+00
             8.5689E+00  2.3728E+01 -3.2532E+00 -1.1867E-01  2.7575E+02
 
0ITERATION NO.:    7    OBJECTIVE VALUE:  -911.811774772274        NO. OF FUNC. EVALS.:   3
 CUMULATIVE NO. OF FUNC. EVALS.:       30
 NPARAMETR:  1.8468E+00  1.5855E+00  4.7595E-01  1.6715E+00  2.4930E-01  5.6402E-03  2.6540E-02 -1.6300E-02  1.2572E-01  7.6569E-03
             1.2478E-02  1.3722E-01  3.9832E-03  2.0174E-01  4.4508E-02
 PARAMETER:  9.2342E-02  7.9275E-02  2.3797E-02  8.3575E-02  3.5401E-01  4.3751E-02  2.0587E-01 -1.2644E-01  1.3416E-02  8.2443E-02
             1.5010E-01  4.7784E-02  6.0166E-02  2.4769E-01 -1.2006E+00
 GRADIENT:   3.1524E+03  1.3260E+02 -7.6869E+02 -9.4158E+03  3.0314E+01  5.7476E+00  4.8348E+00  5.6692E+01 -3.7283E+01  5.1300E+00
             1.9813E+00  2.9061E+00 -2.4544E+01 -1.8814E+02 -1.7337E+02
 
0ITERATION NO.:    8    OBJECTIVE VALUE:  -925.502906976777        NO. OF FUNC. EVALS.:   4
 CUMULATIVE NO. OF FUNC. EVALS.:       34
 NPARAMETR:  1.8961E+00  1.5530E+00  6.4049E-01  1.8080E+00  2.7503E-01 -1.7942E-02  9.1392E-02 -5.3345E-03  1.7447E-01 -9.3874E-03
             9.3137E-03  2.4633E-01  1.5791E-02  1.4700E-01  4.0295E-02
 PARAMETER:  9.4806E-02  7.7650E-02  3.2025E-02  9.0402E-02  4.0312E-01 -1.3250E-01  6.7494E-01 -3.9396E-02  1.7441E-01 -3.4068E-02
             8.9173E-02  2.8625E-01  1.6830E-01  8.8879E-02 -1.2504E+00
 GRADIENT:   3.4204E+03 -2.0810E+01  8.4332E+02 -1.0603E+04  2.1999E+01 -3.6306E+00  3.9366E+00  6.9345E+01 -1.4605E+00  2.6906E-01
             2.1125E+00  1.6916E+01 -1.7431E+01 -2.0436E+02 -1.6644E+02
 
0ITERATION NO.:    9    OBJECTIVE VALUE:  -949.047048123192        NO. OF FUNC. EVALS.:   3
 CUMULATIVE NO. OF FUNC. EVALS.:       37
 NPARAMETR:  2.0579E+00  1.5313E+00  7.4088E-01  2.0322E+00  4.0555E-01 -4.9799E-02  1.9291E-01  7.1238E-03  1.4650E-01 -3.6020E-02
            -1.5945E-03  3.0462E-01  4.6385E-02  9.5728E-02  4.0372E-02
 PARAMETER:  1.0290E-01  7.6566E-02  3.7044E-02  1.0161E-01  5.9731E-01 -3.0286E-01  1.1732E+00  4.3324E-02  6.9093E-02 -1.3627E-01
            -7.9539E-03  2.7662E-01  4.1122E-01 -1.6705E-01 -1.2494E+00
 GRADIENT:   3.9247E+03 -2.4386E+02  7.3773E+02 -9.0268E+03  1.2950E+01 -5.8741E+00  6.0558E+00  7.3296E+01 -1.4507E+01 -3.1219E+00
             8.5365E+00 -7.5714E+00 -1.0457E+01 -1.5671E+02 -1.8320E+02
 
0ITERATION NO.:   10    OBJECTIVE VALUE:  -956.541286726200        NO. OF FUNC. EVALS.:   4
 CUMULATIVE NO. OF FUNC. EVALS.:       41
 NPARAMETR:  2.1244E+00  1.5402E+00  8.0520E-01  2.1274E+00  4.5237E-01 -5.9057E-02  2.4070E-01 -1.2534E-02  1.2861E-01 -4.4028E-02
            -7.0471E-03  3.6470E-01  5.0232E-02  7.7373E-02  4.1434E-02
 PARAMETER:  1.0622E-01  7.7008E-02  4.0260E-02  1.0637E-01  6.5193E-01 -3.4007E-01  1.3860E+00 -7.2172E-02 -5.6258E-03 -1.5010E-01
            -1.0340E-01  3.2933E-01  5.0880E-01 -3.2722E-01 -1.2364E+00
 GRADIENT:   4.0131E+03 -9.5270E+01  3.1890E+01 -6.4375E+03  2.6738E+00 -8.6744E+00  1.4512E+01  5.0719E+01 -2.1195E+01 -2.8347E+00
             1.1501E+01 -3.2141E+01  6.9520E+00 -1.3724E+02 -1.8570E+02
 
0ITERATION NO.:   11    OBJECTIVE VALUE:  -961.596707341101        NO. OF FUNC. EVALS.:   5
 CUMULATIVE NO. OF FUNC. EVALS.:       46
 NPARAMETR:  2.1035E+00  1.5552E+00  8.6308E-01  2.1307E+00  4.1788E-01 -5.7239E-02  2.5255E-01 -1.6125E-02  1.0013E-01 -4.6411E-02
            -1.1503E-02  4.2261E-01  5.3618E-02  8.1684E-02  4.2025E-02
 PARAMETER:  1.0517E-01  7.7758E-02  4.3154E-02  1.0654E-01  6.1228E-01 -3.4293E-01  1.5131E+00 -9.6608E-02 -1.4064E-01 -1.6106E-01
            -1.8687E-01  3.9522E-01  5.2410E-01 -3.1308E-01 -1.2293E+00
 GRADIENT:   3.8061E+03  2.3843E+02  5.3583E+02 -6.5413E+03 -6.9711E-01 -1.1448E+01  1.3154E+01  4.6606E+01 -4.7058E+01 -2.9727E+00
             1.3793E+01 -1.8829E+01  5.9225E+00 -1.2683E+02 -1.8769E+02
 
0ITERATION NO.:   12    OBJECTIVE VALUE:  -969.252354191598        NO. OF FUNC. EVALS.:   3
 CUMULATIVE NO. OF FUNC. EVALS.:       49
 NPARAMETR:  1.9966E+00  1.6558E+00  8.8886E-01  2.0441E+00  2.9810E-01 -2.8297E-02  2.4138E-01 -2.8499E-02  1.1273E-01 -3.4551E-02
            -5.6603E-02  3.7615E-01  3.1601E-02  1.4668E-01  4.3472E-02
 PARAMETER:  9.9830E-02  8.2792E-02  4.4443E-02  1.0221E-01  4.4340E-01 -2.0073E-01  1.7122E+00 -2.0216E-01 -5.2648E-02 -1.4527E-01
            -7.4024E-01  1.9387E-01  5.0362E-01 -1.0216E-01 -1.2124E+00
 GRADIENT:   3.1427E+03  1.1859E+02  1.1496E+03 -5.8526E+03 -5.3403E+01 -7.4258E+00  3.5367E+01  1.7495E+01 -2.8552E+01  4.4096E-01
            -6.2277E+00 -6.8667E+01  1.6370E+01 -8.7455E+01 -1.8329E+02
 
0ITERATION NO.:   13    OBJECTIVE VALUE:  -981.666140620434        NO. OF FUNC. EVALS.:   3
 CUMULATIVE NO. OF FUNC. EVALS.:       52
 NPARAMETR:  2.0328E+00  1.7254E+00  9.5112E-01  2.1279E+00  3.5786E-01 -5.1193E-03  2.4084E-01 -1.8251E-02  1.1987E-01 -1.3554E-02
            -9.6971E-02  3.7023E-01  3.7888E-02  1.8960E-01  4.2568E-02
 PARAMETER:  1.0164E-01  8.6270E-02  4.7556E-02  1.0639E-01  5.3475E-01 -3.3144E-02  1.5593E+00 -1.1816E-01 -1.0179E-02 -1.2092E-01
            -1.1631E+00  2.6592E-01  4.0630E-01 -9.0569E-02 -1.2229E+00
 GRADIENT:   3.4208E+03  8.9723E+02  6.8831E+02 -3.5075E+03 -1.0393E+01 -1.1919E+01  2.3725E+01  1.1935E+01 -3.6584E+01  8.1426E+00
            -3.1678E+01 -3.7288E+01  2.3244E+00 -6.0247E+01 -1.8784E+02
 
0ITERATION NO.:   14    OBJECTIVE VALUE:  -1041.29409378614        NO. OF FUNC. EVALS.:   5
 CUMULATIVE NO. OF FUNC. EVALS.:       57
 NPARAMETR:  1.9207E+00  1.7293E+00  8.9968E-01  2.1223E+00  2.7641E-01  5.8862E-02  8.2855E-02 -4.6380E-02  2.0781E-01 -3.4206E-02
            -9.7202E-02  3.4265E-01  8.2423E-02  2.2078E-01  4.8134E-02
 PARAMETER:  9.6037E-02  8.6467E-02  4.4984E-02  1.0612E-01  4.0563E-01  4.3361E-01  6.1035E-01 -3.4166E-01  2.3412E-01 -4.8581E-01
            -8.1819E-01  4.5747E-01  5.8465E-01  1.2665E-01 -1.1615E+00
 GRADIENT:   2.1223E+03 -1.6156E+02  2.1030E+03 -4.5368E+03  2.9122E+01  1.0491E+01 -1.0464E+00  1.3128E+01  1.7864E+01 -5.6454E+00
            -1.4144E+01  7.5634E+00  6.3552E-01 -3.4789E+01 -2.7488E+01
 
0ITERATION NO.:   15    OBJECTIVE VALUE:  -1051.72386483009        NO. OF FUNC. EVALS.:   3
 CUMULATIVE NO. OF FUNC. EVALS.:       60
 NPARAMETR:  1.8276E+00  1.4907E+00  8.1025E-01  2.1162E+00  1.8053E-01 -9.5140E-02 -1.4206E-02 -6.4079E-02  2.6031E-01  1.3840E-02
            -2.8738E-02  2.6501E-01  1.9313E-02  2.0973E-01  5.8367E-02
 PARAMETER:  9.1378E-02  7.4535E-02  4.0513E-02  1.0581E-01  1.9264E-01 -8.6722E-01 -1.2949E-01 -5.8409E-01  2.7088E-01  5.7386E-02
            -5.6452E-01  3.8627E-01  1.3871E-01  1.6081E-01 -1.0651E+00
 GRADIENT:   2.0449E+03 -8.8341E+02  1.4132E+03 -3.5886E+03 -2.5638E-01 -2.1206E+01 -4.1089E+00  2.9201E+00  2.9273E+01  6.2465E+00
            -1.9067E+01  2.6532E+01 -5.5368E+00  3.2127E+00  7.3567E+00
 
0ITERATION NO.:   16    OBJECTIVE VALUE:  -1058.56595491568        NO. OF FUNC. EVALS.:   3
 CUMULATIVE NO. OF FUNC. EVALS.:       63
 NPARAMETR:  1.8362E+00  1.4825E+00  8.9774E-01  2.1838E+00  1.8025E-01 -9.4532E-02 -7.8236E-03 -6.5828E-02  2.5612E-01  2.1191E-02
            -4.0673E-03  2.1521E-01 -2.9415E-02  1.6955E-01  6.2335E-02
 PARAMETER:  9.1808E-02  7.4123E-02  4.4887E-02  1.0919E-01  1.9185E-01 -8.6236E-01 -7.1370E-02 -6.0051E-01  2.6216E-01  1.5568E-01
            -3.5158E-01  2.8059E-01 -2.7742E-01  5.0774E-02 -1.0322E+00
 GRADIENT:   2.2996E+03 -7.5425E+02  1.7763E+03 -2.8794E+03 -5.2034E+00 -2.2494E+01 -2.7827E+00 -5.5953E-01  2.9598E+01  5.5042E+00
            -1.5383E+01  1.9768E+01 -8.9798E+00  6.1995E+00  6.6589E+00
 
0ITERATION NO.:   17    OBJECTIVE VALUE:  -1076.92519561179        NO. OF FUNC. EVALS.:   4
 CUMULATIVE NO. OF FUNC. EVALS.:       67
 NPARAMETR:  1.7885E+00  1.5813E+00  9.3306E-01  2.2324E+00  1.7783E-01 -2.7446E-02  6.9694E-03 -4.1331E-02  2.4042E-01  1.0714E-01
             1.8081E-02  2.9912E-01 -1.4144E-02  1.6013E-01  5.9994E-02
 PARAMETER:  8.9423E-02  7.9066E-02  4.6653E-02  1.1162E-01  1.8510E-01 -2.5206E-01  6.4008E-02 -3.7959E-01  3.2922E-01  9.2197E-01
             9.9700E-02  3.5812E-01 -1.5792E-01  1.0142E-01 -1.0513E+00
 GRADIENT:   1.6439E+03 -4.7461E+02  1.4054E+03 -2.9820E+03  7.9532E+00 -1.0174E+01  1.2804E+00  5.3977E-01  4.9908E+01  9.3565E+00
            -7.6902E+00  2.6794E+01 -1.0190E+01  4.3171E+00  1.8656E+01
 
0ITERATION NO.:   18    OBJECTIVE VALUE:  -1097.55962457245        NO. OF FUNC. EVALS.:   3
 CUMULATIVE NO. OF FUNC. EVALS.:       70
 NPARAMETR:  1.7026E+00  1.6434E+00  9.3485E-01  2.3148E+00  1.5518E-01  3.0985E-02 -8.8425E-03 -2.6551E-02  2.1104E-01  4.2328E-02
             2.8762E-02  2.5472E-01 -1.7372E-02  1.4820E-01  6.0085E-02
 PARAMETER:  8.5131E-02  8.2168E-02  4.6742E-02  1.1574E-01  1.1696E-01  3.0464E-01 -8.6938E-02 -2.6104E-01  2.5804E-01  4.0337E-01
             3.1161E-01  3.4893E-01 -2.3360E-01  5.3920E-02 -1.0506E+00
 GRADIENT:   5.3057E+01  5.7439E+02  1.2223E+03 -2.0227E+03 -1.2903E+01  1.3904E+01 -3.1515E+00 -4.4055E+00  3.2255E+01 -1.3964E+00
             3.1155E+00  3.2442E+01 -1.4158E+01  5.7129E+00  2.1123E+01
 
0ITERATION NO.:   19    OBJECTIVE VALUE:  -1109.11767713088        NO. OF FUNC. EVALS.:   3
 CUMULATIVE NO. OF FUNC. EVALS.:       73
 NPARAMETR:  1.7036E+00  1.5792E+00  8.9754E-01  2.3605E+00  1.7214E-01  2.0646E-02 -3.2400E-03 -1.1672E-02  1.6748E-01  1.9930E-02
             3.5546E-02  2.3041E-01 -1.3245E-02  1.2568E-01  6.1958E-02
 PARAMETER:  8.5180E-02  7.8960E-02  4.4877E-02  1.1802E-01  1.6883E-01  1.9273E-01 -3.0245E-02 -1.0896E-01  1.4990E-01  2.0711E-01
             3.7658E-01  3.1319E-01 -1.6635E-01 -2.6119E-02 -1.0352E+00
 GRADIENT:   3.7165E+02 -3.4525E+02  7.1968E+02 -1.1685E+03  5.4997E+00  8.4661E+00 -2.8092E+00  3.5564E+00  1.7893E+01 -3.6782E+00
             4.6492E+00  2.9396E+01 -1.3004E+01 -4.0655E+00  2.4164E+01
 
0ITERATION NO.:   20    OBJECTIVE VALUE:  -1115.04399158079        NO. OF FUNC. EVALS.:   3
 CUMULATIVE NO. OF FUNC. EVALS.:       76
 NPARAMETR:  1.6781E+00  1.5851E+00  8.1410E-01  2.3531E+00  1.7620E-01  1.3516E-02 -1.0146E-02  4.3508E-03  1.3807E-01  2.4355E-02
             2.6242E-02  1.9498E-01  1.4816E-02  1.2879E-01  6.2347E-02
 PARAMETER:  8.3903E-02  7.9254E-02  4.0705E-02  1.1765E-01  1.8049E-01  1.2470E-01 -9.3616E-02  4.0143E-02  5.7028E-02  2.8110E-01
             2.8978E-01  2.2180E-01  1.0436E-01  7.5973E-03 -1.0321E+00
 GRADIENT:  -6.3372E+01 -3.0717E+02 -4.9643E+01 -8.3806E+02  7.7569E+00  6.2186E+00 -1.0839E+01  1.6036E+01  4.1963E+00  1.4212E-01
             1.6910E+00  1.3130E+01 -3.3398E+00 -1.1295E+01  3.0005E+01
 
0ITERATION NO.:   21    OBJECTIVE VALUE:  -1117.83913054308        NO. OF FUNC. EVALS.:   3
 CUMULATIVE NO. OF FUNC. EVALS.:       79
 NPARAMETR:  1.6824E+00  1.6016E+00  8.1965E-01  2.3548E+00  1.8436E-01 -2.2999E-03  2.8922E-02 -1.4957E-03  1.2448E-01  5.0473E-03
             4.9925E-03  1.8895E-01  2.9690E-02  1.2005E-01  5.7671E-02
 PARAMETER:  8.4118E-02  8.0078E-02  4.0983E-02  1.1774E-01  2.0312E-01 -2.0746E-02  2.6088E-01 -1.3491E-02  8.8679E-03  6.3473E-02
             5.8376E-02  2.0682E-01  3.0512E-01 -2.6739E-02 -1.0711E+00
 GRADIENT:  -8.6986E+01 -1.2794E+02  4.0001E+02 -9.4104E+02  1.4949E+01 -9.1674E-01  2.1535E+00  6.1681E+00 -3.0262E+00 -1.5988E+00
            -1.2276E+00 -2.5188E+00  2.2586E+00 -2.4092E+01 -2.6442E+00
 
0ITERATION NO.:   22    OBJECTIVE VALUE:  -1119.58891144160        NO. OF FUNC. EVALS.:   3
 CUMULATIVE NO. OF FUNC. EVALS.:       82
 NPARAMETR:  1.6642E+00  1.5981E+00  8.1340E-01  2.3648E+00  1.6774E-01 -6.0318E-03  1.0416E-02 -7.7303E-03  1.3864E-01  1.6430E-02
             1.3038E-02  1.9206E-01  2.6423E-02  1.2855E-01  5.7334E-02
 PARAMETER:  8.3211E-02  7.9907E-02  4.0670E-02  1.1824E-01  1.5589E-01 -5.7039E-02  9.8494E-02 -7.3101E-02  6.2075E-02  1.8700E-01
             1.4199E-01  2.2074E-01  2.5681E-01  9.2142E-03 -1.0740E+00
 GRADIENT:  -4.3974E+02 -1.0850E+02  1.5853E+02 -5.1820E+02  3.9814E+00 -2.8327E+00 -1.6696E+00  6.1518E+00  5.0601E+00  4.2649E-01
            -2.2220E-01  4.2024E+00 -7.8758E-01 -1.3193E+01  7.4151E-01
 
0ITERATION NO.:   23    OBJECTIVE VALUE:  -1120.23792685303        NO. OF FUNC. EVALS.:   3
 CUMULATIVE NO. OF FUNC. EVALS.:       85
 NPARAMETR:  1.6832E+00  1.6220E+00  8.0174E-01  2.3696E+00  1.6719E-01  1.6194E-03  4.3994E-03 -1.5149E-02  1.3876E-01  1.8367E-02
             1.3348E-02  1.8929E-01  3.0474E-02  1.3553E-01  5.8534E-02
 PARAMETER:  8.4161E-02  8.1098E-02  4.0087E-02  1.1848E-01  1.5423E-01  1.5339E-02  4.1672E-02 -1.4349E-01  6.3211E-02  2.0369E-01
             1.5000E-01  2.1376E-01  2.9671E-01  2.7854E-02 -1.0637E+00
 GRADIENT:  -7.1666E+01  2.6695E+02 -8.8602E+01 -3.3463E+02  4.1731E+00  1.5958E+00 -3.2596E+00  1.9641E+00  4.2160E+00  6.3162E-01
             3.5530E-01  3.6030E+00  5.8562E-01 -9.8374E+00  7.4693E+00
 
0ITERATION NO.:   24    OBJECTIVE VALUE:  -1120.88486830832        NO. OF FUNC. EVALS.:   3
 CUMULATIVE NO. OF FUNC. EVALS.:       88
 NPARAMETR:  1.6763E+00  1.6127E+00  8.1449E-01  2.3835E+00  1.6422E-01 -1.7402E-03  1.1913E-02 -1.4226E-02  1.3350E-01  1.5078E-02
             1.1160E-02  1.8453E-01  2.9062E-02  1.4216E-01  5.7729E-02
 PARAMETER:  8.3814E-02  8.0634E-02  4.0724E-02  1.1917E-01  1.4528E-01 -1.6632E-02  1.1386E-01 -1.3596E-01  4.3889E-02  1.7230E-01
             1.2477E-01  2.0069E-01  2.9803E-01  5.4898E-02 -1.0706E+00
 GRADIENT:  -2.3172E+02  6.5671E+01  4.4082E+01 -1.2730E+02 -1.3852E-01 -7.2331E-02  3.7062E-01  8.1425E-02  1.7858E+00  1.3782E-01
            -7.1907E-01  7.2697E-01 -3.3955E-02 -3.4373E+00  1.7711E+00
 
0ITERATION NO.:   25    OBJECTIVE VALUE:  -1121.00256486305        NO. OF FUNC. EVALS.:   3
 CUMULATIVE NO. OF FUNC. EVALS.:       91
 NPARAMETR:  1.6835E+00  1.6082E+00  8.1584E-01  2.3900E+00  1.6548E-01 -1.5606E-03  1.1208E-02 -1.4754E-02  1.3158E-01  1.5819E-02
             1.2877E-02  1.8266E-01  2.9639E-02  1.4581E-01  5.7518E-02
 PARAMETER:  8.4174E-02  8.0408E-02  4.0792E-02  1.1950E-01  1.4911E-01 -1.4858E-02  1.0671E-01 -1.4047E-01  3.6660E-02  1.8177E-01
             1.4540E-01  1.9528E-01  3.0231E-01  6.6233E-02 -1.0724E+00
 GRADIENT:  -5.6328E+01 -4.3993E+01 -2.1891E+01  1.6216E+01  1.2432E+00 -1.0218E-01  1.2965E-01 -4.7150E-01  4.2434E-01  1.1980E-01
            -2.3189E-01 -2.1966E-01 -2.4912E-02 -1.3762E+00 -8.0365E-02
 
0ITERATION NO.:   26    OBJECTIVE VALUE:  -1121.01921752323        NO. OF FUNC. EVALS.:   3
 CUMULATIVE NO. OF FUNC. EVALS.:       94
 NPARAMETR:  1.6862E+00  1.6118E+00  8.1822E-01  2.3911E+00  1.6549E-01 -5.2716E-04  1.2199E-02 -1.3478E-02  1.3084E-01  1.6555E-02
             1.3045E-02  1.8388E-01  3.0545E-02  1.4921E-01  5.7534E-02
 PARAMETER:  8.4310E-02  8.0588E-02  4.0911E-02  1.1955E-01  1.4914E-01 -5.0189E-03  1.1614E-01 -1.2832E-01  3.3894E-02  1.8994E-01
             1.4883E-01  1.9777E-01  3.0978E-01  7.8089E-02 -1.0723E+00
 GRADIENT:  -1.3621E+01  2.2509E+00 -1.1085E+01  2.2540E+00  5.2675E-01  2.4061E-01  2.0356E-01 -2.7526E-01 -7.7126E-02  1.4224E-01
            -3.0760E-01  3.3408E-02 -3.2183E-01  9.4982E-01  7.8609E-01
 
0ITERATION NO.:   27    OBJECTIVE VALUE:  -1121.02580215966        NO. OF FUNC. EVALS.:   3
 CUMULATIVE NO. OF FUNC. EVALS.:       97
 NPARAMETR:  1.6866E+00  1.6110E+00  8.1812E-01  2.3921E+00  1.6505E-01 -7.6212E-04  1.1994E-02 -1.3262E-02  1.3117E-01  1.5748E-02
             1.3684E-02  1.8630E-01  3.2130E-02  1.4873E-01  5.7242E-02
 PARAMETER:  8.4332E-02  8.0552E-02  4.0906E-02  1.1961E-01  1.4780E-01 -7.2654E-03  1.1434E-01 -1.2643E-01  3.5138E-02  1.8066E-01
             1.5574E-01  2.0503E-01  3.2362E-01  7.4473E-02 -1.0748E+00
 GRADIENT:   3.1529E-01 -2.9507E+00 -2.2919E+01  2.7920E+01  1.4999E-01  9.2498E-02 -3.5980E-02 -1.1729E-01 -1.4289E-01 -6.5824E-03
            -5.9127E-04  4.8637E-02 -8.5941E-02 -4.0679E-01 -2.7796E-01
 
0ITERATION NO.:   28    OBJECTIVE VALUE:  -1121.02781408265        NO. OF FUNC. EVALS.:   3
 CUMULATIVE NO. OF FUNC. EVALS.:      100
 NPARAMETR:  1.6869E+00  1.6111E+00  8.1867E-01  2.3914E+00  1.6502E-01 -9.1701E-04  1.2201E-02 -1.3020E-02  1.3126E-01  1.5918E-02
             1.3717E-02  1.8703E-01  3.2665E-02  1.4941E-01  5.7192E-02
 PARAMETER:  8.4344E-02  8.0556E-02  4.0934E-02  1.1957E-01  1.4772E-01 -8.7428E-03  1.1632E-01 -1.2413E-01  3.5478E-02  1.8269E-01
             1.5594E-01  2.0682E-01  3.2831E-01  7.6438E-02 -1.0753E+00
 GRADIENT:   2.9137E+00 -1.4539E+00 -1.0184E+01  5.4834E+00  7.7739E-02 -4.0562E-02 -3.5787E-03 -5.3739E-02 -7.8611E-02  3.0002E-02
            -3.8902E-02  9.3908E-02 -8.3377E-02 -6.7395E-02 -1.9786E-01
 
0ITERATION NO.:   29    OBJECTIVE VALUE:  -1121.02827624596        NO. OF FUNC. EVALS.:   3
 CUMULATIVE NO. OF FUNC. EVALS.:      103
 NPARAMETR:  1.6869E+00  1.6113E+00  8.1962E-01  2.3916E+00  1.6502E-01 -7.0977E-04  1.2448E-02 -1.2693E-02  1.3129E-01  1.6045E-02
             1.3874E-02  1.8758E-01  3.3106E-02  1.4980E-01  5.7165E-02
 PARAMETER:  8.4346E-02  8.0566E-02  4.0981E-02  1.1958E-01  1.4771E-01 -6.7670E-03  1.1868E-01 -1.2102E-01  3.5591E-02  1.8396E-01
             1.5792E-01  2.0816E-01  3.3201E-01  7.7437E-02 -1.0755E+00
 GRADIENT:  -1.1290E-02  7.9249E-01 -6.7244E-01 -6.0627E-01 -6.9841E-02  1.7968E-02  1.4280E-02  2.3291E-02 -7.9651E-02  1.3617E-02
            -1.2780E-02  7.5431E-02 -5.8799E-02  2.6527E-02 -5.9081E-02
 
0ITERATION NO.:   30    OBJECTIVE VALUE:  -1121.02834988548        NO. OF FUNC. EVALS.:   3
 CUMULATIVE NO. OF FUNC. EVALS.:      106
 NPARAMETR:  1.6870E+00  1.6113E+00  8.1955E-01  2.3915E+00  1.6503E-01 -7.5235E-04  1.2408E-02 -1.2715E-02  1.3137E-01  1.5934E-02
             1.3863E-02  1.8758E-01  3.3227E-02  1.4989E-01  5.7155E-02
 PARAMETER:  8.4348E-02  8.0565E-02  4.0978E-02  1.1958E-01  1.4773E-01 -7.1728E-03  1.1830E-01 -1.2123E-01  3.5922E-02  1.8266E-01
             1.5770E-01  2.0824E-01  3.3336E-01  7.7597E-02 -1.0756E+00
 GRADIENT:   7.3871E-01  6.6180E-01 -8.0091E-02 -1.2265E+00 -3.9671E-02 -2.1896E-03 -3.0892E-03  1.7190E-02 -3.6092E-02  6.1395E-04
            -1.2179E-02  3.0483E-02 -2.3262E-02  2.2485E-02 -6.2663E-02
 
0ITERATION NO.:   31    OBJECTIVE VALUE:  -1121.02837063808        NO. OF FUNC. EVALS.:   3
 CUMULATIVE NO. OF FUNC. EVALS.:      109
 NPARAMETR:  1.6870E+00  1.6113E+00  8.1959E-01  2.3916E+00  1.6505E-01 -7.5531E-04  1.2413E-02 -1.2738E-02  1.3142E-01  1.5967E-02
             1.3904E-02  1.8756E-01  3.3280E-02  1.4990E-01  5.7164E-02
 PARAMETER:  8.4348E-02  8.0564E-02  4.0980E-02  1.1958E-01  1.4779E-01 -7.2006E-03  1.1833E-01 -1.2144E-01  3.6099E-02  1.8301E-01
             1.5814E-01  2.0817E-01  3.3386E-01  7.7514E-02 -1.0755E+00
 GRADIENT:   6.0976E-01 -5.2345E-02 -2.5268E-02 -1.9506E-01 -1.4015E-02 -6.2102E-03  2.3792E-03 -1.0681E-04 -3.0543E-03  3.4551E-03
            -9.7754E-04  1.1625E-03  2.8457E-03 -1.1369E-02 -1.8771E-03
 
0ITERATION NO.:   32    OBJECTIVE VALUE:  -1121.02837222258        NO. OF FUNC. EVALS.:   3
 CUMULATIVE NO. OF FUNC. EVALS.:      112
 NPARAMETR:  1.6869E+00  1.6113E+00  8.1959E-01  2.3916E+00  1.6505E-01 -7.4384E-04  1.2403E-02 -1.2739E-02  1.3143E-01  1.5950E-02
             1.3902E-02  1.8753E-01  3.3262E-02  1.4990E-01  5.7164E-02
 PARAMETER:  8.4347E-02  8.0564E-02  4.0980E-02  1.1958E-01  1.4782E-01 -7.0911E-03  1.1824E-01 -1.2144E-01  3.6133E-02  1.8280E-01
             1.5811E-01  2.0808E-01  3.3372E-01  7.7546E-02 -1.0755E+00
 GRADIENT:   8.7751E-02 -7.8878E-02  6.3650E-02 -2.2900E-02 -3.7131E-03  7.0731E-04 -1.4696E-03  1.0322E-03  8.0146E-04 -8.6998E-04
            -5.5908E-04 -2.9930E-03  9.0731E-04 -1.8466E-03 -1.1813E-03
 
0ITERATION NO.:   33    OBJECTIVE VALUE:  -1121.02837222258        NO. OF FUNC. EVALS.:   1
 CUMULATIVE NO. OF FUNC. EVALS.:      113
 NPARAMETR:  1.6869E+00  1.6113E+00  8.1959E-01  2.3916E+00  1.6505E-01 -7.4384E-04  1.2403E-02 -1.2739E-02  1.3143E-01  1.5950E-02
             1.3902E-02  1.8753E-01  3.3262E-02  1.4990E-01  5.7164E-02
 PARAMETER:  8.4347E-02  8.0564E-02  4.0980E-02  1.1958E-01  1.4782E-01 -7.0911E-03  1.1824E-01 -1.2144E-01  3.6133E-02  1.8280E-01
             1.5811E-01  2.0808E-01  3.3372E-01  7.7546E-02 -1.0755E+00
 GRADIENT:   8.7751E-02 -7.8878E-02  6.3650E-02 -2.2900E-02 -3.7131E-03  7.0731E-04 -1.4696E-03  1.0322E-03  8.0146E-04 -8.6998E-04
            -5.5908E-04 -2.9930E-03  9.0731E-04 -1.8466E-03 -1.1813E-03
 
0ITERATION NO.:   34    OBJECTIVE VALUE:  -1121.02837222258        NO. OF FUNC. EVALS.:   0
 CUMULATIVE NO. OF FUNC. EVALS.:      113
 NPARAMETR:  1.6869E+00  1.6113E+00  8.1959E-01  2.3916E+00  1.6505E-01 -7.4384E-04  1.2403E-02 -1.2739E-02  1.3143E-01  1.5950E-02
             1.3902E-02  1.8753E-01  3.3262E-02  1.4990E-01  5.7164E-02
 PARAMETER:  8.4347E-02  8.0564E-02  4.0980E-02  1.1958E-01  1.4782E-01 -7.0911E-03  1.1824E-01 -1.2144E-01  3.6133E-02  1.8280E-01
             1.5811E-01  2.0808E-01  3.3372E-01  7.7546E-02 -1.0755E+00
 GRADIENT:   8.7751E-02 -7.8878E-02  6.3650E-02 -2.2900E-02 -3.7131E-03  7.0731E-04 -1.4696E-03  1.0322E-03  8.0146E-04 -8.6998E-04
            -5.5908E-04 -2.9930E-03  9.0731E-04 -1.8466E-03 -1.1813E-03
 
 #TERM:
0MINIMIZATION SUCCESSFUL
 NO. OF FUNCTION EVALUATIONS USED:      113
 NO. OF SIG. DIGITS IN FINAL EST.:  3.5

 ETABAR IS THE ARITHMETIC MEAN OF THE ETA-ESTIMATES,
 AND THE P-VALUE IS GIVEN FOR THE NULL HYPOTHESIS THAT THE TRUE MEAN IS 0.
 
 ETABAR:        -9.0712E-06 -1.1912E-02 -3.4882E-03 -1.1581E-02
 SE:             3.9192E-02  2.8850E-02  3.2733E-02  3.3061E-02
 N:                     100         100         100         100
 
 P VAL.:         9.9982E-01  6.7969E-01  9.1513E-01  7.2612E-01
 
 ETASHRINKSD(%)  3.0453E+00  2.0021E+01  2.4031E+01  1.4177E+01
 ETASHRINKVR(%)  5.9978E+00  3.6033E+01  4.2287E+01  2.6344E+01
 EBVSHRINKSD(%)  3.3163E+00  1.9861E+01  2.4451E+01  1.5063E+01
 EBVSHRINKVR(%)  6.5226E+00  3.5777E+01  4.2923E+01  2.7858E+01
 EPSSHRINKSD(%)  3.0940E+01
 EPSSHRINKVR(%)  5.2308E+01
 
  
 TOTAL DATA POINTS NORMALLY DISTRIBUTED (N):          500
 N*LOG(2PI) CONSTANT TO OBJECTIVE FUNCTION:    918.938533204673     
 OBJECTIVE FUNCTION VALUE WITHOUT CONSTANT:   -1121.02837222258     
 OBJECTIVE FUNCTION VALUE WITH CONSTANT:      -202.089839017911     
 REPORTED OBJECTIVE FUNCTION DOES NOT CONTAIN CONSTANT
  
 TOTAL EFFECTIVE ETAS (NIND*NETA):                           400
  
 #TERE:
 Elapsed estimation  time in seconds:     9.56
 Elapsed covariance  time in seconds:     2.01
 Elapsed postprocess time in seconds:     0.22
1
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 ************************************************************************************************************************
 ********************                                                                                ********************
 ********************               FIRST ORDER CONDITIONAL ESTIMATION WITH INTERACTION              ********************
 #OBJT:**************                       MINIMUM VALUE OF OBJECTIVE FUNCTION                      ********************
 ********************                                                                                ********************
 ************************************************************************************************************************
 





 #OBJV:********************************************    -1121.028       **************************************************
1
 ************************************************************************************************************************
 ********************                                                                                ********************
 ********************               FIRST ORDER CONDITIONAL ESTIMATION WITH INTERACTION              ********************
 ********************                             FINAL PARAMETER ESTIMATE                           ********************
 ********************                                                                                ********************
 ************************************************************************************************************************
 


 THETA - VECTOR OF FIXED EFFECTS PARAMETERS   *********


         TH 1      TH 2      TH 3      TH 4     
 
         1.69E+00  1.61E+00  8.20E-01  2.39E+00
 


 OMEGA - COV MATRIX FOR RANDOM EFFECTS - ETAS  ********


         ETA1      ETA2      ETA3      ETA4     
 
 ETA1
+        1.65E-01
 
 ETA2
+       -7.44E-04  1.31E-01
 
 ETA3
+        1.24E-02  1.59E-02  1.88E-01
 
 ETA4
+       -1.27E-02  1.39E-02  3.33E-02  1.50E-01
 


 SIGMA - COV MATRIX FOR RANDOM EFFECTS - EPSILONS  ****


         EPS1     
 
 EPS1
+        5.72E-02
 
1


 OMEGA - CORR MATRIX FOR RANDOM EFFECTS - ETAS  *******


         ETA1      ETA2      ETA3      ETA4     
 
 ETA1
+        4.06E-01
 
 ETA2
+       -5.05E-03  3.63E-01
 
 ETA3
+        7.05E-02  1.02E-01  4.33E-01
 
 ETA4
+       -8.10E-02  9.90E-02  1.98E-01  3.87E-01
 


 SIGMA - CORR MATRIX FOR RANDOM EFFECTS - EPSILONS  ***


         EPS1     
 
 EPS1
+        2.39E-01
 
1
 ************************************************************************************************************************
 ********************                                                                                ********************
 ********************               FIRST ORDER CONDITIONAL ESTIMATION WITH INTERACTION              ********************
 ********************                            STANDARD ERROR OF ESTIMATE                          ********************
 ********************                                                                                ********************
 ************************************************************************************************************************
 


 THETA - VECTOR OF FIXED EFFECTS PARAMETERS   *********


         TH 1      TH 2      TH 3      TH 4     
 
         4.32E-02  4.78E-02  7.05E-02  5.18E-02
 


 OMEGA - COV MATRIX FOR RANDOM EFFECTS - ETAS  ********


         ETA1      ETA2      ETA3      ETA4     
 
 ETA1
+        2.71E-02
 
 ETA2
+        2.14E-02  3.15E-02
 
 ETA3
+        3.05E-02  3.54E-02  7.82E-02
 
 ETA4
+        2.39E-02  2.35E-02  4.61E-02  3.97E-02
 


 SIGMA - COV MATRIX FOR RANDOM EFFECTS - EPSILONS  ****


         EPS1     
 
 EPS1
+        8.27E-03
 
1


 OMEGA - CORR MATRIX FOR RANDOM EFFECTS - ETAS  *******


         ETA1      ETA2      ETA3      ETA4     
 
 ETA1
+        3.34E-02
 
 ETA2
+        1.46E-01  4.34E-02
 
 ETA3
+        1.65E-01  2.28E-01  9.03E-02
 
 ETA4
+        1.57E-01  1.63E-01  2.24E-01  5.13E-02
 


 SIGMA - CORR MATRIX FOR RANDOM EFFECTS - EPSILONS  ***


         EPS1     
 
 EPS1
+        1.73E-02
 
1
 ************************************************************************************************************************
 ********************                                                                                ********************
 ********************               FIRST ORDER CONDITIONAL ESTIMATION WITH INTERACTION              ********************
 ********************                          COVARIANCE MATRIX OF ESTIMATE                         ********************
 ********************                                                                                ********************
 ************************************************************************************************************************
 

            TH 1      TH 2      TH 3      TH 4      OM11      OM12      OM13      OM14      OM22      OM23      OM24      OM33  
             OM34      OM44      SG11  
 
 TH 1
+        1.87E-03
 
 TH 2
+        2.46E-04  2.29E-03
 
 TH 3
+        5.79E-04  2.36E-04  4.96E-03
 
 TH 4
+        2.44E-04  3.27E-04  1.97E-03  2.68E-03
 
 OM11
+        7.39E-05  1.38E-04  2.01E-04  1.65E-04  7.35E-04
 
 OM12
+        7.92E-05  1.30E-04  2.61E-04  1.71E-04  1.39E-04  4.58E-04
 
 OM13
+        1.12E-04  1.87E-04  3.83E-05  2.14E-04  2.76E-04  1.59E-04  9.29E-04
 
 OM14
+        9.39E-05  1.32E-04  2.36E-04  2.14E-04  1.49E-04  1.46E-04  4.30E-04  5.71E-04
 
 OM22
+       -3.85E-06  3.72E-05 -2.48E-04 -7.23E-05  2.03E-05  9.71E-05  1.06E-04  6.78E-05  9.92E-04
 
 OM23
+        5.65E-05  9.64E-05  8.31E-04  2.48E-04  6.00E-05  1.69E-04 -6.00E-05  2.24E-05 -5.02E-05  1.25E-03
 
 OM24
+        3.11E-05 -1.39E-05  3.14E-04  1.84E-04  3.74E-05  5.74E-05  5.26E-05  9.99E-05  1.38E-04  3.36E-04  5.51E-04
 
 OM33
+        2.57E-04  1.74E-05  9.09E-04  6.96E-04  3.61E-04  3.57E-04  1.09E-03  6.81E-04  3.90E-04 -5.56E-06  2.49E-04  6.12E-03
 
 OM34
+        1.57E-04  6.73E-05  3.50E-04  3.11E-04  2.04E-04  2.11E-04  5.83E-04  4.53E-04  2.63E-04 -3.23E-05  2.21E-04  2.96E-03
          2.13E-03
 
 OM44
+        1.06E-04  1.38E-04  1.28E-04  2.23E-04  1.42E-04  1.48E-04  3.58E-04  2.95E-04  2.19E-04 -1.43E-05  2.50E-04  1.56E-03
          1.32E-03  1.58E-03
 
 SG11
+        5.85E-06  1.02E-05 -7.81E-06 -1.72E-05 -3.61E-05 -4.18E-05 -8.30E-05 -6.24E-05 -7.70E-05  1.73E-05 -2.54E-05 -3.75E-04
         -2.21E-04 -1.55E-04  6.84E-05
 
1
 ************************************************************************************************************************
 ********************                                                                                ********************
 ********************               FIRST ORDER CONDITIONAL ESTIMATION WITH INTERACTION              ********************
 ********************                          CORRELATION MATRIX OF ESTIMATE                        ********************
 ********************                                                                                ********************
 ************************************************************************************************************************
 

            TH 1      TH 2      TH 3      TH 4      OM11      OM12      OM13      OM14      OM22      OM23      OM24      OM33  
             OM34      OM44      SG11  
 
 TH 1
+        4.32E-02
 
 TH 2
+        1.19E-01  4.78E-02
 
 TH 3
+        1.90E-01  7.00E-02  7.05E-02
 
 TH 4
+        1.09E-01  1.32E-01  5.40E-01  5.18E-02
 
 OM11
+        6.30E-02  1.07E-01  1.05E-01  1.18E-01  2.71E-02
 
 OM12
+        8.55E-02  1.27E-01  1.73E-01  1.54E-01  2.40E-01  2.14E-02
 
 OM13
+        8.48E-02  1.29E-01  1.78E-02  1.36E-01  3.34E-01  2.43E-01  3.05E-02
 
 OM14
+        9.09E-02  1.16E-01  1.40E-01  1.73E-01  2.30E-01  2.85E-01  5.90E-01  2.39E-02
 
 OM22
+       -2.82E-03  2.47E-02 -1.12E-01 -4.43E-02  2.38E-02  1.44E-01  1.11E-01  9.01E-02  3.15E-02
 
 OM23
+        3.69E-02  5.69E-02  3.33E-01  1.35E-01  6.25E-02  2.22E-01 -5.56E-02  2.65E-02 -4.50E-02  3.54E-02
 
 OM24
+        3.06E-02 -1.23E-02  1.90E-01  1.51E-01  5.88E-02  1.14E-01  7.35E-02  1.78E-01  1.87E-01  4.04E-01  2.35E-02
 
 OM33
+        7.60E-02  4.66E-03  1.65E-01  1.72E-01  1.70E-01  2.13E-01  4.57E-01  3.64E-01  1.58E-01 -2.01E-03  1.36E-01  7.82E-02
 
 OM34
+        7.88E-02  3.05E-02  1.08E-01  1.30E-01  1.63E-01  2.13E-01  4.15E-01  4.11E-01  1.81E-01 -1.98E-02  2.04E-01  8.19E-01
          4.61E-02
 
 OM44
+        6.17E-02  7.28E-02  4.57E-02  1.09E-01  1.31E-01  1.74E-01  2.95E-01  3.11E-01  1.75E-01 -1.02E-02  2.68E-01  5.03E-01
          7.22E-01  3.97E-02
 
 SG11
+        1.64E-02  2.57E-02 -1.34E-02 -4.02E-02 -1.61E-01 -2.36E-01 -3.29E-01 -3.16E-01 -2.96E-01  5.89E-02 -1.31E-01 -5.79E-01
         -5.80E-01 -4.72E-01  8.27E-03
 
1
 ************************************************************************************************************************
 ********************                                                                                ********************
 ********************               FIRST ORDER CONDITIONAL ESTIMATION WITH INTERACTION              ********************
 ********************                      INVERSE COVARIANCE MATRIX OF ESTIMATE                     ********************
 ********************                                                                                ********************
 ************************************************************************************************************************
 

            TH 1      TH 2      TH 3      TH 4      OM11      OM12      OM13      OM14      OM22      OM23      OM24      OM33  
             OM34      OM44      SG11  
 
 TH 1
+        5.70E+02
 
 TH 2
+       -4.66E+01  4.71E+02
 
 TH 3
+       -6.81E+01  6.29E+00  3.40E+02
 
 TH 4
+        1.20E+01 -4.84E+01 -2.15E+02  5.53E+02
 
 OM11
+       -1.16E+01 -4.02E+01 -3.27E+01 -1.63E+01  1.60E+03
 
 OM12
+       -4.42E+01 -7.52E+01 -4.16E+01 -5.16E+01 -2.89E+02  2.75E+03
 
 OM13
+       -3.66E+01 -6.88E+01  1.19E+02 -6.77E+01 -4.17E+02 -9.47E+01  2.04E+03
 
 OM14
+       -1.68E+01 -4.42E+01 -8.84E+01 -2.72E+01  1.05E+01 -3.67E+02 -1.18E+03  3.03E+03
 
 OM22
+       -1.35E+01 -3.24E+01  6.88E+01  1.36E+01  4.94E+01 -2.05E+02 -1.88E+01  6.67E+01  1.18E+03
 
 OM23
+        2.69E+01 -4.11E+01 -1.54E+02  6.72E+01 -3.20E+01 -3.81E+02  7.87E+01  7.02E+01  1.02E+02  1.14E+03
 
 OM24
+        6.10E+00  8.79E+01 -2.84E+01 -8.31E+01  4.34E-01  1.93E+02  5.50E+01 -2.95E+02 -3.45E+02 -6.89E+02  2.54E+03
 
 OM33
+       -5.26E+00  2.57E+01 -4.92E+01 -3.32E+01  2.17E+01  2.13E+00 -2.57E+02  1.36E+02  9.32E-01 -2.30E+01  5.57E+01  6.09E+02
 
 OM34
+       -2.48E+01  5.39E+00  8.21E+00  4.92E+01  4.47E+00 -7.54E+00  1.10E+02 -3.96E+02  3.11E+00  5.44E+01 -6.16E+01 -8.41E+02
          2.44E+03
 
 OM44
+       -1.67E+01 -6.07E+01  3.37E+01 -4.53E+01 -1.40E+01 -3.17E+01 -3.14E+01  4.76E+01  4.16E+00  6.30E+01 -3.39E+02  2.25E+02
         -1.11E+03  1.49E+03
 
 SG11
+       -3.06E+02 -2.42E+02 -4.99E+01 -1.84E+02  3.36E+02  9.28E+02 -1.27E+01  6.23E+02  1.16E+03 -3.22E+02 -5.59E+01  9.59E+02
          5.21E+02  8.75E+02  2.62E+04
 
1
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 ************************************************************************************************************************
 ********************                                                                                ********************
 ********************               FIRST ORDER CONDITIONAL ESTIMATION WITH INTERACTION              ********************
 ********************                      EIGENVALUES OF COR MATRIX OF ESTIMATE                     ********************
 ********************                                                                                ********************
 ************************************************************************************************************************
 

             1         2         3         4         5         6         7         8         9        10        11        12
             13        14        15
 
         1.19E-01  3.30E-01  3.88E-01  4.32E-01  4.59E-01  5.74E-01  7.53E-01  8.12E-01  8.66E-01  8.79E-01  1.00E+00  1.17E+00
          1.36E+00  1.94E+00  3.91E+00
 
 Elapsed finaloutput time in seconds:     0.05
 #CPUT: Total CPU Time in Seconds,       10.374
Stop Time: 
Mon 10/22/2018 
01:16 PM
