% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/applyTransform.r
\name{applyTransform}
\alias{applyTransform}
\alias{applyTransform.matrix}
\alias{applyTransform.mesh3d}
\alias{applyTransform.default}
\title{apply affine transformation to data}
\usage{
applyTransform(x, trafo, ...)

\method{applyTransform}{matrix}(x, trafo, inverse = FALSE, threads = 1, ...)

\method{applyTransform}{mesh3d}(x, trafo, inverse = FALSE, threads = 1, ...)

\method{applyTransform}{default}(x, trafo, inverse = FALSE, threads = 1, ...)
}
\arguments{
\item{x}{matrix or mesh3d}

\item{trafo}{4x4 transformation matrix or an object of class "tpsCoeff"}

\item{...}{additional arguments, currently not used.}

\item{inverse}{logical: if TRUE, the inverse of the transformation is applied (for TPS coefficients have to be recomputed)}

\item{threads}{threads to be used for parallel execution in tps deformation.}
}
\value{
the transformed object
}
\description{
apply affine transformation to data
}
\examples{
data(boneData)
rot <- rotonto(boneLM[,,1],boneLM[,,2])
trafo <- getTrafo4x4(rot)
boneLM2trafo <- applyTransform(boneLM[,,2],trafo)
}
\seealso{
\code{\link{rotonto}, link{rotmesh.onto}, \link{tps3d}, \link{computeTransform}}
}
