% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cov.mtx.R
\name{cov.mtx}
\alias{cov.mtx}
\title{Simulates Correlation matrix by a given SEM model.}
\usage{
cov.mtx(Model, nobs)
}
\arguments{
\item{Model}{A lavaan model object specifying the measurement and structural components of the SEM.}

\item{nobs}{An integer indicating the number of observed indicators (xs) in the model.}
}
\value{
Returns model implied covariance and correlation matrices.
}
\description{
This function generates the model-implied covariance and correlation matrices based on a specified structural equation model (SEM).
The function returns the implied covariance and correlation matrices.
}
\examples{
LavaanM <- '
# Measurement model (fixed factor loading)
F1 =~ 0.7*x1 + 0.7*x2 + 0.7*x3
F2 =~ 0.7*x4 + 0.7*x5 + 0.7*x6
F3 =~ 0.7*x7 + 0.7*x8 + 0.7*x9
# Structural regressions
F2 ~ 0.4*F1
F3 ~ 0.6*F1
# Fix latent variances
F1 ~~ 1*F1
# Residual variances
F2 ~~ 1*F2
F3 ~~ 1*F3
# Correlated residuals
F2 ~~ 0.5*F3
'

cov.mtx(Model=LavaanM, nobs=9)
}
\author{
Fatih Orçan
}
