% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixreg.R
\name{mixreg}
\alias{mixreg}
\title{MLE of Mixture Regression with Normal Errors}
\usage{
mixreg(x, y, C = 2, nstart = 20, tol = 1e-05)
}
\arguments{
\item{x}{an n by p data matrix where n is the number of observations and p is the number of explanatory variables.
The intercept term will automatically be added to the data.}

\item{y}{an n-dimensional vector of response variable.}

\item{C}{number of mixture components. Default is 2.}

\item{nstart}{number of initializations to try. Default is 20.}

\item{tol}{stopping criteria (threshold value) for the EM algorithm. Default is 1e-05.}
}
\value{
A list containing the following elements:
\item{pi}{C-dimensional vector of estimated mixing proportions.}
\item{beta}{C by (p + 1) matrix of estimated regression coefficients.}
\item{sigma}{C-dimensional vector of estimated standard deviations.}
\item{lik}{final likelihood.}
\item{run}{total number of iterations after convergence.}
}
\description{
`mixreg' provides the MLE estimates of a mixture of regression models with normal errors.
The result from this function can be used as initial values of the \code{\link{mixregRM2}} function.
}
\examples{
data(tone)
y = tone$tuned
x = tone$stretchratio
k = 160
x[151:k] = 0
y[151:k] = 5
est = mixreg(x, y, 2, nstart = 1)
}
\seealso{
\code{\link{mixregRM2}}
}
