% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dada_phyloseq.R
\name{learn_idtaxa}
\alias{learn_idtaxa}
\title{A wrapper of \code{\link[DECIPHER:LearnTaxa]{DECIPHER::LearnTaxa()}}}
\usage{
learn_idtaxa(
  fasta_for_training,
  output_Rdata = NULL,
  output_path_only = FALSE,
  unite = FALSE,
  ...
)
}
\arguments{
\item{fasta_for_training}{A fasta file (can be gzip) to train the trainingSet
using the function \code{\link[=learn_idtaxa]{learn_idtaxa()}}. Only used if trainingSet is NULL.

The reference database must contain
taxonomic information in the header of each sequence in the form of a string
starting with ";tax=" and followed by a comma-separated list of up to nine
taxonomic identifiers.

The only exception is if \code{unite=TRUE}. In that case the UNITE taxonomy is
automatically formatted.}

\item{output_Rdata}{A vector naming the path to an output Rdata file. If
left to NULL, no Rdata file is written.}

\item{output_path_only}{(logical, default FALSE). If TRUE, the function
return only the path to the output_Rdata file. Note that output_Rdata must
be set.}

\item{unite}{(logical, default FALSE). If set to TRUE, the fasta_for_training
file is formatted from UNITE format to sintax one, needed in
fasta_for_training. Only used if trainingSet is NULL.}

\item{...}{Additional arguments passed on to \code{\link[DECIPHER:LearnTaxa]{DECIPHER::LearnTaxa()}}}
}
\value{
Either a Taxa Train object (see \code{\link[DECIPHER:LearnTaxa]{DECIPHER::LearnTaxa()}}) or, if
output_path_only is TRUE, a vector indicating the path to the output
training object.
}
\description{
\if{html}{\out{
<a href="https://adrientaudiere.github.io/MiscMetabar/articles/Rules.html#lifecycle">
<img src="https://img.shields.io/badge/lifecycle-experimental-orange" alt="lifecycle-experimental"></a>
}}


This function is basically a wrapper of functions \code{\link[DECIPHER:LearnTaxa]{DECIPHER::LearnTaxa()}},
please cite the DECIPHER package if you use this function.
}
\details{
This function is mainly a wrapper of the work of others.
Please make a reference to \code{\link[DECIPHER:LearnTaxa]{DECIPHER::LearnTaxa()}} if you
use this function.
}
\examples{
\dontrun{
training_mini_UNITE_fungi <-
  learn_idtaxa(fasta_for_training = system.file("extdata",
    "mini_UNITE_fungi.fasta.gz",
    package = "MiscMetabar"
  ))
plot(training_mini_UNITE_fungi)

training_100sp_UNITE <-
  learn_idtaxa(
    fasta_for_training = system.file("extdata",
      "100_sp_UNITE_sh_general_release_dynamic.fasta",
      package = "MiscMetabar"
    ),
    unite = TRUE
  )

plot(training_100sp_UNITE)
}
}
\seealso{
\code{\link[=assign_idtaxa]{assign_idtaxa()}}
}
\author{
Adrien Taudière
}
