% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unique_subformula_masses.R
\name{unique_subformula_masses}
\alias{unique_subformula_masses}
\title{unique_subformula_masses}
\usage{
unique_subformula_masses(fml, names = TRUE, check_validity = FALSE)
}
\arguments{
\item{fml}{Chemical formula.}

\item{names}{Return respective sub formulas as vector names.}

\item{check_validity}{Filter for chemically valid formulas.}
}
\value{
A named numeric vector. The names are the sub formulas for the calculated
  exact masses given as numeric.
}
\description{
\code{unique_subformula_masses} will generate a numeric vector of
  potential sub formula masses regarding a chemical formula as input.
}
\details{
In mass spectrometry precursor masses are often fragmented and these
  fragments are recorded as MS^2 spectra. A frequent task is then to compute
  potential chemical formulas for the obtained MS^2 masses. The function
  \code{unique_subformula_masses} follows the reverse approach. It allows to
  calculate all masses that could be potential breakdown products of a precursor
  formula
}
\examples{
# specify a formula and calculate all potential combinatorial masses
fml <- c("C6H12O6", "C11H16NO4PS", "C24H51O4P")[1]
tmp <- unique_subformula_masses(fml = fml)
length(tmp); any(duplicated(tmp))
hist(tmp, breaks=seq(floor(min(tmp))-1, ceiling(max(tmp))), main=fml)
# do the same as above but check for chemical plausibility
tmp2 <- unique_subformula_masses(fml = fml, check_validity=TRUE)
length(tmp2)
hist(tmp2, breaks=seq(floor(min(tmp2))-1, ceiling(max(tmp2))), main=fml)
mz <- 147
tmp[abs(tmp-mz)<0.5]
tmp2[abs(tmp2-mz)<0.5]
}
