% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iSCAM2OM.R
\name{iSCAM2OM}
\alias{iSCAM2OM}
\alias{iSCAM2Data}
\title{Reads MPD or MCMC estimates and data from iSCAM file structure into an operating model}
\usage{
iSCAM2OM(
  iSCAMdir,
  nsim = 48,
  proyears = 50,
  mcmc = FALSE,
  spawn_time_frac = 0,
  Name = "iSCAM model",
  Source = "No source provided",
  length_timestep = 1,
  nyr_par_mu = 2,
  Author = "No author provided",
  report = FALSE,
  silent = FALSE
)

iSCAM2Data(
  iSCAMdir,
  Name = "iSCAM assessment",
  Source = "No source provided",
  length_timestep = 1,
  Author = "No author provided"
)
}
\arguments{
\item{iSCAMdir}{A folder with iSCAM input and output files in it. Alternatively, a list returned by
\link{load.iscam.files}.}

\item{nsim}{The number of simulations to take for parameters with
uncertainty (for OM@cpars custom parameters)}

\item{proyears}{The number of MSE projection years}

\item{mcmc}{Logical, whether to use mcmc samples to create custom parameters cpars. Alternatively, a list
returned by \link{read.mcmc}. Set the seed for the function to sub-sample the mcmc samples.}

\item{spawn_time_frac}{Numeric between 0-1 indicating when spawning occurs within the time step}

\item{Name}{The name of the operating model}

\item{Source}{Reference to assessment documentation e.g. a url}

\item{length_timestep}{How long is a model time step in years
(e.g. a quarterly model is 0.25, a monthly model 1/12) (currently only uses annual time step)}

\item{nyr_par_mu}{integer, the number of recent years to estimate vulnerability over for future projections}

\item{Author}{Who did the assessment}

\item{report}{logical should a numbers at age reconstruction plot be produced?}

\item{silent}{logical should progress reporting be printed to the console?}
}
\description{
Functions for importing an iSCAM assessment. From a fitted model, \code{iSCAM2OM}
populates the various slots of an operating model and \code{iSCAM2Data} generates a Data object.
These functions rely on several functions written by Chris Grandin (DFO PBS).
}
\section{Biological parameters}{

The function calls \code{model <- load.iscam.files(iSCAMdir)} and grabs the following matrices:

\itemize{
\item \code{model$mpd$d3_weight_mat} - fecundity (product of weight and maturity at age)
\item \code{model$mpd$ma} - maturity at age
}
}

\section{MPD historical reconstruction}{

The function calls \code{model <- load.iscam.files(iSCAMdir)} and then grabs the following matrices:

\itemize{
\item \code{model$mpd$N} - abundance at age
\item \code{model$mpd$F} - fishing mortality at age
\item \code{model$mpd$M} - natural mortality at age
}

If a delay-difference model is recognized, then the following is used instead:
\itemize{
\item \code{model$mpd$F_dd} - fishing mortality at age
\item \code{model$mpd$M_dd} - natural mortality at age
}

Abundance at age is reconstructed using \code{model$mpd$rt} (recruitment) and projected with \code{F_dd} and
\code{M_dd} to match \code{model$mpd$numbers}.
}

\section{MCMC historical reconstruction}{

If \code{mcmc = TRUE} the function calls \code{mcmc_model <- read.mcmc(iSCAMdir)}, and grabs \code{nsim} sub-samples of the MCMC output
through the following arrays:

\itemize{
\item \code{mcmc_model$params} and \code{mcmc_model$ft} - fishing mortality at age from the fleet selectivity parameters and apical F's
\item \code{mcmc_model$m} - year-specific natural mortality at age
\item \code{mcmc_model$params$rinit} and \code{mcmc_model$rt} - recruitment and abundance
}
}

\section{Start age}{

While the iSCAM start age can be greater than zero, abundance at age is back-calculated to age zero with M, maturity, growth = 0. In this
way, the stock-recruit dynamics from iSCAM are preserved.

These arrays are then passed to \link{Assess2OM} to generate the operating model.
}

\section{Reference points}{

iSCAM calculates the stock-recruit relationship and subsequently a single set of MSY and unfished reference
points using R0, steepness, and unfished spawners per recruit from the mean M, fecundity, and growth (mean with
respect to time).

R0 and h are recalculated for the operating model by obtaining the stock-recruit alpha and beta from the
iSCAM parameters and the mean unfished spawners per recruit in the first \code{ageM} (age of 50\% maturity) years.
}

\author{
T. Carruthers, Q. Huynh
}
