% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MATESmain.R
\name{MATES_test}
\alias{MATES_test}
\title{MATES test statistic with pre-computed view matrices}
\usage{
MATES_test(UxUy, R_list, m, n, perm = NULL)
}
\arguments{
\item{UxUy}{A numeric vector of length 2*S containing the Ux and Uy statistics
for each view}

\item{R_list}{A list of numeric matrices with length S}

\item{m}{An integer representing the number of sample in X}

\item{n}{An integer representing the number of sample in Y}

\item{perm}{An integer indicating the number of permutation (default is NULL,
which uses closed form)}
}
\value{
A list with the MATES test statistic (test.stat) and p-value (pval)
}
\description{
This function takes a list of view matrices (R_list) and other parameters
to compute the MATES test statistic.
}
\examples{
\donttest{
# Generate simulated data
set.seed(123)
X <- matrix(rnorm(20), ncol = 2)  # 10 samples, 2 dimensions
Y <- matrix(rnorm(20), ncol = 2)  # 10 samples, 2 dimensions
Z <- rbind(X, Y)
m <- nrow(X)
n <- nrow(Y)
N <- m + n

# Compute distance and similarity matrices
D <- as.matrix(dist(Z, method = "manhattan"))
S <- max(D) - D

# Compute rank matrix (simplified NNG approach)
R <- matrix(0, N, N)
k <- 3
for(i in 1:N) {
  neighbors <- order(D[i,])[2:(k+1)]  # k nearest neighbors
  R[i, neighbors] <- 1:k
}
R <- R + t(R)

# Create list with one rank matrix
R_list <- list(R)

# Calculate test statistics (Ux and Uy)
sample1ID <- 1:m
sample2ID <- (m+1):N
Ux <- sum(R[sample1ID, sample1ID])
Uy <- sum(R[sample2ID, sample2ID])
UxUy <- c(Ux, Uy)

# Perform MATES test
result <- MATES_test(UxUy, R_list, m = m, n = n)
print(result$test.stat)
print(result$pval)
}
}
