% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RLum-class.R
\docType{class}
\name{RLum-class}
\alias{RLum-class}
\title{Class \code{"RLum"}}
\description{
Abstract class for data in the package Luminescence
Subclasses are:
}
\details{
\strong{RLum-class}\cr
|\cr
|----\linkS4class{RLum.Data}\cr
|----|-- \linkS4class{RLum.Data.Curve}\cr
|----|-- \linkS4class{RLum.Data.Spectrum}\cr
|----|-- \linkS4class{RLum.Data.Image}\cr
|----\linkS4class{RLum.Analysis}\cr
|----\linkS4class{RLum.Results}
}
\section{Slots}{

\describe{
\item{\code{originator}}{Object of class \link{character} containing the name of the producing
function for the object. Set automatically by using the function \link{set_RLum}.}

\item{\code{info}}{Object of class \link{list} for additional information on the object itself}

\item{\code{.uid}}{Object of class \link{character} for a unique object identifier. This id is
usually calculated using the internal function \code{create_UID()} if the function \link{set_RLum}
is called.}

\item{\code{.pid}}{Object of class \link{character} for a parent id. This allows nesting RLum-objects
at will. The parent id can be the uid of another object.}
}}

\note{
\code{RLum} is a virtual class.
}
\section{Objects from the Class}{

A virtual Class: No objects can be created from it.
}

\section{Class version}{
 0.4.0
}

\examples{

showClass("RLum")

}
\seealso{
\linkS4class{RLum.Data}, \linkS4class{RLum.Data.Curve}, \linkS4class{RLum.Data.Spectrum}, \linkS4class{RLum.Data.Image},
\linkS4class{RLum.Analysis}, \linkS4class{RLum.Results}, \link{methods_RLum}
}
\author{
Sebastian Kreutzer, Institute of Geography, Heidelberg University (Germany)
, RLum Developer Team}
\keyword{classes}
