% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wlm.R
\name{wlm}
\alias{wlm}
\title{Weighted Longitudinal Mean (WLM)}
\usage{
wlm(data, subject_id, time, response, k = 2, verbose = FALSE)
}
\arguments{
\item{data}{A dataframe containing longitudinal data.}

\item{subject_id}{A column specifying the column name representing subject IDs.}

\item{time}{A column specifying different time points that observations are measured.}

\item{response}{A column specifying the column name representing the response variable.}

\item{k}{A numeric value specifying the threshold multiplier for detecting influential subjects (default: 2).}

\item{verbose}{Logical; if TRUE, prints informative messages during execution.}
}
\value{
A list containing:
\item{influential_subjects}{A vector of subject IDs identified as influential.}
\item{influential_data}{A dataframe of influential subjects' data.}
\item{non_influential_data}{A dataframe of non-influential subjects' data.}
\item{weighted_plot}{A ggplot object showing the weighted mean response for each subject.}
\item{longitudinal_plot}{A ggplot object visualizing the longitudinal data with influential subjects highlighted.}
\item{IS_table}{A data frame containing the Influence Score (IS) and the Partial Influence Score (PIS) values for each subject at each time point.}
}
\description{
This function identifies influential subjects in a longitudinal dataset based on their
weighted mean response values. It computes weighted averages for each subject and
detects anomalies by comparing them against an overall mean threshold.
}
\details{
The function follows these steps:
\itemize{
  \item Computes the weighted mean response for each subject.
  \item Calculates the overall mean and standard deviation of weighted responses.
  \item Identifies subjects whose weighted mean response deviates beyond \code{k} standard deviations.
  \item Separates data into influential and non-influential subjects.
  \item Provides visualizations of the detected anomalies using \code{ggplot2}.
}

This method is beneficial for detecting influential subjects in longitudinal studies, where responses
may vary over time and require weighted adjustments.
}
\examples{
data(infsdata)
infsdata <- infsdata[1:5,]
result <- wlm(infsdata, "subject_id", "time", "response", k = 2)
print(result$influential_subjects)
head(result$influential_data)
head(result$non_influential_data)
print(result$weighted_plot)
print(result$longitudinal_plot)

}
\seealso{
tvm, slm, sld, rld
}
