% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rgeneric_utils.R
\name{rgeneric_get}
\alias{rgeneric_get}
\alias{initial.rgeneric}
\alias{mu.rgeneric}
\alias{graph.rgeneric}
\alias{prec.rgeneric}
\alias{prior.rgeneric}
\title{\code{rgeneric_get} is an internal function used by
\code{graph}, \code{pred}, \code{initial}, \code{mu} or \code{prior}
methods for \code{rgeneric}.}
\usage{
rgeneric_get(
  model,
  cmd = c("graph", "Q", "initial", "mu", "log_prior"),
  theta,
  optimize = TRUE
)

\method{initial}{rgeneric}(model)

\method{mu}{rgeneric}(model, theta)

\method{graph}{rgeneric}(model, optimize)

\method{prec}{rgeneric}(model, theta, optimize)

\method{prior}{rgeneric}(model, theta)
}
\arguments{
\item{model}{a \code{rgeneric} object.}

\item{cmd}{an string to specify which model element to get}

\item{theta}{numeric vector with the model parameters.
If missing, the \code{\link[=initial]{initial()}} will be used.}

\item{optimize}{logical indicating if it is to be
returned only the elements and not as a sparse matrix.}
}
\value{
depends on \code{cmd}

numeric scalar (if numeric vector is provided
for theta) or vector (if numeric matrix is provided
for theta).
}
\description{
The \code{generic_get} retrieve a model property specified by
\code{cmd} on an \code{rgeneric} object.
The functions listed below are for each \code{cmd} case.
}
\section{Functions}{
\itemize{
\item \code{initial(rgeneric)}: Retrive the initial parameter(s) of an \code{rgeneric} model.

\item \code{mu(rgeneric)}: Evaluate the mean for an \code{rgeneric} model.

\item \code{graph(rgeneric)}: Retrieve the graph of an \code{rgeneric} object

\item \code{prec(rgeneric)}: Retrieve the precision of an \code{rgeneric} object

\item \code{prior(rgeneric)}: Evaluate the prior for an \code{rgeneric} model

}}
\examples{
library(INLAtools)
old.par <- par(no.readonly = TRUE)

## Setting the prior parameters
prior.par <- c(1, 0.5) # P(sigma > 1) = 0.5
cmodel <- cgeneric(
  model = "iid", n = 10,
  param = prior.par)

## prior summaries: sigma and log-precision
(lamb <- -log(prior.par[2])/prior.par[1])
(smedian <- qexp(0.5, lamb))
(smean <- 1/lamb)

## mode: at the minimum of - log-prior
(lpmode <- optimize(function(x)
  -prior(cmodel, theta = x),
  c(-10, 30))$minimum)
## mean: integral of x*f(x)dx
(lpmean <- integrate(function(x)
  exp(prior(cmodel, theta = matrix(x, 1)))*x,
  -10, 30)$value)

## prior visualization: log(precision) and sigma
par(mfrow = c(1, 2))
plot(function(x)
 exp(prior(cmodel, theta = matrix(x, nrow=1))),
  -3, 3, n = 601, xlab = "log-precision",
  ylab = "density")
abline(v = lpmode, lwd = 3, col = 2)
rug(-2*log(smedian), lwd = 3, col = 3)
rug(lpmean, lwd = 3, col = 4)
plot(function(x)
 exp(prior(cmodel,
  theta = matrix(
    -2*log(x),
    nrow = 1))+log(2)-log(x)),
  1/100, 10, n = 1000,
  xlab = expression(sigma),
  ylab = "density")
plot(function(x) dexp(x, lamb),
   1/100, 10, n = 1000,
   add = TRUE, lty = 2, col = 2)
rug(smedian, lwd = 3, col = 3)
rug(smean, lwd = 3, col = 4)

par(old.par)
}
