% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/barrierModel.define.R
\name{barrierModel.define}
\alias{barrierModel.define}
\title{Define a spacetime model object for the \code{f()} call.}
\usage{
barrierModel.define(
  mesh,
  barrier.triangles,
  prior.range,
  prior.sigma,
  range.fraction = 0.1,
  constr = FALSE,
  debug = FALSE,
  useINLAprecomp = TRUE,
  libpath = NULL
)
}
\arguments{
\item{mesh}{a spatial mesh}

\item{barrier.triangles}{a integer vector to specify which
triangles centers are in the barrier domain,
or a list with integer vector if more than one.}

\item{prior.range}{numeric vector containing U and a
to define the probability statements P(range < U) = a
used to setup the PC-prior for range.
If a = 0 or a = NA, then U is taken to be the fixed value for the range.}

\item{prior.sigma}{numeric vector containing U and a
to define the probability statements P(range > U) = a
used to setup the PC-prior for sigma.
If a = 0 or a = NA, then U is taken to be the fixed value for sigma.}

\item{range.fraction}{numeric to specify the fraction of the range
for the barrier domain. Default value is 0.1.
This has to be specified with care in order to have it small enough
to make it act as barrier but not too small in order to
prevent numerical issues.}

\item{constr}{logical, default is FALSE, to indicate if the
integral of the field over the domain is to be constrained to zero.}

\item{debug}{integer, default is zero, indicating the verbose level.
Will be used as logical by INLA.}

\item{useINLAprecomp}{logical, default is TRUE, indicating if it is to
be used the shared object pre-compiled by INLA.
This is not considered if 'libpath' is provided.}

\item{libpath}{string, default is NULL, with the path to the shared object.}
}
\value{
objects to be used in the f() formula term in INLA.
}
\description{
Define a spacetime model object for the \code{f()} call.
}
\details{
See the paper.
}
