% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pval.R
\name{post_pred_pval}
\alias{post_pred_pval}
\title{Posterior Predictive p-value}
\usage{
post_pred_pval(
  yrep,
  y,
  test_statistic = mean,
  alternative = c("two.sided", "less", "greater"),
  plot = FALSE
)
}
\arguments{
\item{yrep}{Matrix of posterior replications with rows corresponding to samples and columns to simulated observations.}

\item{y}{Vector of observations.}

\item{test_statistic}{Function of the test statistic to compute the p-value for.}

\item{alternative}{Indicates the alternative hypothesis: must be one of \code{"two.sided"}, \code{"greater"} or \code{"less"}.}

\item{plot}{Whether to output a plot visualising the distribution of the test statistic.}
}
\value{
List containing the p-value and (optionally) a ggplot.
}
\description{
Compute and plot posterior predictive p-value (Bayesian p-value) from samples of a distribution.
The simulations and observations are first summarised into a test statistics,
then the test statistic of the observations is compared to the test statistic of the empirical distribution.
}
\examples{
post_pred_pval(matrix(rnorm(1e3), ncol = 10), rnorm(10), plot = TRUE)
}
