\name{IC}
\alias{IC}
\title{Calculate Information Criteria for HMM/HSMM Models}
\description{
Computes information criteria (AIC3, AICu, HQC, BICadj) for Hidden Markov Models (HMM) or Hidden Semi-Markov Models (HSMM).
}
\usage{
IC(data, model, type)
}
\arguments{
  \item{data}{Numeric vector of observations.}
  \item{model}{Fitted HMM or HSMM model object.}
  \item{type}{Character string: \code{"AIC3"}, \code{"AICu"}, \code{"HQC"}, or \code{"BICadj"}.}
}
\details{
Automatically detects HMM vs HSMM models based on \code{dwellparameters} presence.

Information criteria formulas:
\itemize{
  \item \strong{AIC3:} \eqn{-2 \log L + 3k}
  \item \strong{AICu:} Unbiased AIC with finite sample correction
  \item \strong{HQC:} \eqn{-2 \log L + 2k \log(\log n)}
  \item \strong{BICadj:} \eqn{-2 \log L + k \log n - k \log(2\pi)}
}
where \eqn{L} is likelihood, \eqn{k} is number of parameters, \eqn{n} is sample size.
}
\value{
Numeric value of the specified information criterion.
}
\examples{

J <- 3
Pi <- matrix(c(0.0, 0.6, 0.4,
               0.5, 0.0, 0.5,
               0.3, 0.7, 0.0), nrow = J, byrow = TRUE)

obspar <- list(
  mean = c(-2, 0, 3),
  sd   = c(1, 1.5, 2)
)

dwellpar <- list(
  lambda = c(3, 5, 4)
)

sim <- generateHSMM(n = 1000, J = J, obsdist = "norm",
                    dwelldist = "pois", obspar = obspar,
                    dwellpar = dwellpar, Pi = Pi)

fit <- findmleHSMM(x = sim$x, J = J, M = 100,
                   obsdist = "norm", dwelldist = "pois",
                   obspar = obspar, dwellpar = dwellpar,
                   Pi = Pi)

AIC3 <- IC(sim, fit, "AIC3")
AICu <- IC(sim, fit, "AICu")
HQC <- IC(sim, fit, "HQC")
BICadj <- IC(sim, fit, "BICadj")


}
\author{
Aimee Cody
}
