% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distance_thinning.R
\name{compute_neighbors_local_kdtree}
\alias{compute_neighbors_local_kdtree}
\title{Compute Neighbors Using Local kd-Trees}
\usage{
compute_neighbors_local_kdtree(
  coordinates,
  thin_dist,
  distance = c("haversine", "euclidean"),
  R = 6371,
  n_cores = 1
)
}
\arguments{
\item{coordinates}{A matrix of coordinates to thin, with two columns representing longitude and latitude.}

\item{thin_dist}{A positive numeric value representing the thinning distance in kilometers.}

\item{distance}{A character string specifying the distance metric to use `c("haversine", "euclidean")`.}

\item{R}{A numeric value representing the radius of the Earth in kilometers. The default is 6371 km.}

\item{n_cores}{An integer specifying the number of cores to use for parallel processing. The default is 1.}
}
\value{
A list where each element corresponds to a point and contains the indices of its neighbors, excluding the point itself.
}
\description{
Divides the search area into a grid of local regions and constructs kd-trees
for each region to compute neighbors efficiently. Neighbor regions are
also considered to ensure a complete search.
}
\examples{
set.seed(123)
coords <- matrix(runif(20, min = -180, max = 180), ncol = 2)

# Compute neighbors using local kd-trees with Euclidean distance
neighbors <- compute_neighbors_local_kdtree(coords, thin_dist = 10, n_cores = 1)

}
