% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_covariates.R
\name{extract_names}
\alias{extract_names}
\title{Extract Covariate Names}
\usage{
extract_names(data = NULL, pattern = NULL, name = NULL)
}
\arguments{
\item{data}{A \code{data.frame} containing the variables.}

\item{pattern}{A character vector specifying prefix(es) to match (e.g., "tmin" matches "tmin", "tmin.l1", etc.).}

\item{name}{A character vector of exact variable name(s) to extract.}
}
\value{
A character vector of matched covariate names.
}
\description{
This function allows the user to select variables from a data set by prefix
(using the \code{pattern} argument) or by exact name matching.
The return object is a character vector with the selected covariate names that can be used
as input for \code{\link{cov_add}}, \code{\link{cov_uni}},
\code{\link{cov_multi}}, \code{\link{cov_interact}}, \code{\link{cov_nl}},
and \code{\link{cov_varying}} functions.
}
\examples{
data <- data.frame(tmin = 1:10, tmin.l1 = 1:10, urban = 1:10)
extract_names(data, pattern = "tmin")
extract_names(data, name = "urban")
extract_names(data, pattern = "tmin", name = "urban")
}
