% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GHR_palette.R
\name{GHR_palette}
\alias{GHR_palette}
\alias{GHR_palettes}
\title{Generate GHR color palettes}
\usage{
GHR_palette(palette, ncols = 30)

GHR_palettes()
}
\arguments{
\item{palette}{Name of the GHR, RcolorBrewer or colorspace palette. Use "-"
before the palette name (e.g., "-Reds") to reverse it. A vector of custom
colors is also possible.}

\item{ncols}{Number of colors to sample.}
}
\value{
GHR_palette() returns the function that generates the color palette and the
attribute 'na_color'.\cr
GHR_palettes() returns a plot with the custom GHR palettes.
}
\description{
Generates color palettes including custom, ColorBrewer and
colorspace palettes.

Creates a visualization of all custom GHR palettes.
}
\details{
See all available options by running \code{GHR_palettes()},
\code{RColorBrewer::display.brewer.all()} and \code{colorspace::hcl_palettes(plot=TRUE)}.
}
\examples{
GHR_palette("IDE1", 5)(5)

GHR_palettes()
}
