% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_audit_text.R
\name{gg_audit_text}
\alias{gg_audit_text}
\title{Audit Text Elements for Readability}
\usage{
gg_audit_text(plot)
}
\arguments{
\item{plot}{A ggplot2 object}
}
\value{
A list of issues, warnings, and suggestions
}
\description{
Checks font sizes, label overlap, and text readability issues.
}
\examples{
library(ggplot2)
p <- ggplot(mtcars, aes(x = rownames(mtcars), y = mpg)) +
  geom_col() +
  theme(axis.text.x = element_text(size = 6))
gg_audit_text(p)
}
