% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FuzzyHiperGeometricNaiveBayes.R
\name{FuzzyHipergeometricNaiveBayes}
\alias{FuzzyHipergeometricNaiveBayes}
\title{Fuzzy Hipergeometric Naive Bayes}
\usage{
FuzzyHipergeometricNaiveBayes(train, cl, cores = 2, fuzzy = TRUE)
}
\arguments{
\item{train}{matrix or data frame of training set cases.}

\item{cl}{factor of true classifications of training set}

\item{cores}{how many cores of the computer do you want to use (default = 2)}

\item{fuzzy}{boolean variable to use the membership function}
}
\value{
A vector of classifications
}
\description{
\code{FuzzyHipergeometricNaiveBayes} Fuzzy Hipergeometric Naive Bayes
}
\examples{

set.seed(1) # determining a seed

substituir_zero <- function(x) {
  if (x == 0) {
    while(1){
     new_valor <- rhyper(1,3,30,10)
      if(new_valor != 0){
        return(new_valor)
      }
    }
  } else {
    return(x)
  }
}

#Building dataframe
class1 <- data.frame(rhyper(72,3,30,10), 
                     sample(seq(1,5),72,replace = TRUE), class = "Bem treinado")
colnames(class1)[1] <- "sucessos"
class1$sucessos <- sapply(class1$sucessos, substituir_zero)
colnames(class1)[2] <- "tentativas"
colnames(class1)[3] <- "avaliação"
class2 <- data.frame(rhyper(72,3,17,12), 
                     sample(seq(4,7),72,replace = TRUE), class = "Mediano")
colnames(class2)[1] <- "sucessos"
colnames(class2)[2] <- "tentativas"
colnames(class2)[3] <- "avaliação"
class3 <- data.frame(rhyper(72,3,9,11),
                     sample(seq(7,10),72,replace = TRUE), class = "Precisa treinar")
colnames(class3)[1] <- "sucessos"
colnames(class3)[2] <- "tentativas"
colnames(class3)[3] <- "avaliação"
data <- rbind(class1,class2,class3)


#spliting dataframe
split <- caTools::sample.split(t(data[, 1]), SplitRatio = 0.7)
Train <- subset(data, split == "TRUE")
Test <- subset(data, split == "FALSE")

test <- Test[, -3]
fit_NHT <- FuzzyHipergeometricNaiveBayes(
 train = Train[, -3],
 cl = Train[, 3], cores = 2
)

pred_NHT <- predict(fit_NHT, test)



}
\references{
\insertRef{ferreira2025new}{FuzzyClass}
}
