% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FuzzyGeoNaiveBayes.R
\name{FuzzyGeoNaiveBayes}
\alias{FuzzyGeoNaiveBayes}
\title{Fuzzy Naive Bayes Geometric Classifier}
\usage{
FuzzyGeoNaiveBayes(train, cl, cores = 2, fuzzy = T)
}
\arguments{
\item{train}{matrix or data frame of training set cases.}

\item{cl}{factor of true classifications of training set}

\item{cores}{how many cores of the computer do you want to use (default = 2)}

\item{fuzzy}{boolean variable to use the membership function}
}
\value{
A vector of classifications
}
\description{
\code{FuzzyGeoNaiveBayes} Naive Bayes Geometric Classifier
}
\examples{

set.seed(1) # determining a seed
class1 <- data.frame(vari1 = rgeom(100,prob = 0.2),
                     vari2 = rgeom(100,prob = 0.2),
                     vari3 = rgeom(100,prob = 0.2), class = 1)
class2 <- data.frame(vari1 = rgeom(100,prob = 0.5),
                     vari2 = rgeom(100,prob = 0.5),
                     vari3 = rgeom(100,prob = 0.5), class = 2)
class3 <- data.frame(vari1 = rgeom(100,prob = 0.9),
                     vari2 = rgeom(100,prob = 0.9),
                     vari3 = rgeom(100,prob = 0.9), class = 3)
data <- rbind(class1,class2,class3)

# Splitting into Training and Testing
split <- caTools::sample.split(t(data[, 1]), SplitRatio = 0.7)
Train <- subset(data, split == "TRUE")
Test <- subset(data, split == "FALSE")
# ----------------
# matrix or data frame of test set cases.
# A vector will be interpreted as a row vector for a single case.
test <- Test[, -4]
fit_NBT <- FuzzyGeoNaiveBayes(
  train = Train[, -4],
  cl = Train[, 4], cores = 2
)

pred_NBT <- predict(fit_NBT, test)

head(pred_NBT)
head(Test[, 4])
}
\references{
\insertRef{ferreira2023}{FuzzyClass}
}
