% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forecast_eval_functions.R
\name{dm.test.ewc.fb}
\alias{dm.test.ewc.fb}
\title{Diebold-Mariano Test (EWC, fixed-b approximation)}
\usage{
dm.test.ewc.fb(d, B = NA, Bopt = NA, cl = 0.05)
}
\arguments{
\item{d}{loss differential}

\item{B}{truncation parameter for the EWC long-run variance estimator (if \code{B = NA}, then \code{Bopt = 1} by default)}

\item{Bopt}{option for automatic bandwidth, 1 if Lazarus et al. (2018, default, \eqn{B=\lfloor 0.4T^{2/3}\rfloor})}

\item{cl}{confidence level (default = 0.05, i.e., 5\%)}
}
\value{
This function returns a class with the following elements
\itemize{
\item \code{rej} is a T/F value. TRUE (reject), FALSE (accept)
\item \code{stat} is a test statistic
\item \code{pval} is an associated p-value
}
}
\description{
Diebold-Mariano Test (EWC, fixed-b approximation). This is a two-sided test.
}
\author{
Minchul Shin
}
