
had_deriv_ot_cost_sgn_null <- \(G_u, G_v, costm) {
    ot_cost(G_u, G_v, costm)
}

had_deriv_ot_cost_alt <- \(mu, nu, G_u, G_v, costm) {

    cost0 <- ot_cost(mu, nu, costm)

    opt_prob <- \(z) {
        a <- G_u - z * mu
        b <- G_v - z * nu
        if (any(a < 0) || any(b < 0)) {
            .Machine$double.xmax
        } else {
            ot_cost(a, b, costm) + z * cost0
        }
    }

    res <- stats::optimize(opt_prob, lower = -1e8, upper = 1e8)$objective

    if (res == .Machine$double.xmax) {
        res <- Inf
    }

    res
}
