% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fars_methods.R
\name{coef.fars}
\alias{coef.fars}
\title{Coefficients for \code{fars} Object}
\usage{
\method{coef}{fars}(object, ...)
}
\arguments{
\item{object}{An object of class \code{fars}.}

\item{...}{Additional arguments (ignored).}
}
\value{
A numeric matrix with one column per quantile level and one row per coefficient.
Column names correspond to quantile levels (e.g. \code{0.05}, \code{0.25}, ...),
and row names to coefficient names.
}
\description{
Returns a matrix of estimated coefficients from all quantile regressions stored in a \code{fars} object.
}
\examples{
fars_result <- compute_fars(dep_variable = rnorm(100), 
                            factors = matrix(rnorm(100 * 3), ncol = 3))
coef(fars_result)

}
