\name{testTailHomo}
\alias{testTailHomo}
\title{Test on tail homogeneity}
\usage{
testTailHomo(y, k, alpha = 0.05)
}
\arguments{
\item{y}{list, containing the samples on which the test is to be performed}

\item{k}{integer, number of exceedances for the generalized Pareto}

\item{alpha}{double indicating the confidence level for the test. Default: 0.05}
}
\value{
list of 7 containing
\itemize{
\item \code{gamHatP} the pooled tail index
\item \code{VarGamHatP} the variance of \code{gamHatP}
\item \code{CIGamHatP} \eqn{(1-\alpha)} level confidence interval for \code{gamHatP}
\item \code{BiasGamHatP} bias term of \code{gamHatP}
\item \code{logLikR} value of the likelihood ratio-type of test statistic
\item \code{PVal} p-value of the test
}
}
\description{
Given observed samples and effective sample size, return the results for a likelihood ratio-type test on tail homogeneity.
}
\examples{
\dontrun{
# generate two samples of data
set.seed(1234)
y1 <- evd::rgpd(500, 0, 1, 0.2)
y2 <- evd::rgpd(700, 0, 2, 0.7)
y <- list(y1 = y1, y2 = y2)
# set effective sample size
k <- 50
# perform test
test <- testTailHomo(y,k)
}
}
\references{
Daouia, A., S.A. Padoan and G. Stupfler (2024). Optimal weighted pooling for inference about
the tail index and extreme quantiles, \emph{Bernoulli}, 30(\bold{2}), pp. 1287–1312.
}
