% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indqi.R
\name{hw}
\alias{hw}
\title{Hectolitre weight of cereals}
\usage{
hw(GEN, HL, crop = "trit", stat = "all")
}
\arguments{
\item{GEN}{The column with the genotype name}

\item{HL}{Weight obtained on a 1qt lt scale, as determined by the
Rules for Seed Analysis (RAS), Ministry of Agriculture,
Livestock and Supply (2009).}

\item{crop}{Argument for selecting culture. Use 'trit' for wheat, 'oat' for
white oats, 'rye' for rye and 'barley' for barley}

\item{stat}{Argument to select the function output type. Use 'all' to estimate
the HW for all replicates, or 'mean' to extract the mean for each genotype.}
}
\value{
Returns the estimated value for the hectoliter weight considering the
selected cereal.
}
\description{
Useful function for characterizing the hectolitre weight (HW) of experiments
with cereals.
}
\examples{
library(EstimateBreed)

GEN <- rep(paste("G", 1:5, sep=""), each = 3)
REP <- rep(1:3, times = 5)
MG <- c(78.5, 80.2, 79.1, 81.3, 82.0, 80.8, 76.9, 78.1, 77.5, 83.2,
84.1, 82.9, 77.4, 78.9, 79.3)

data <- data.frame(GEN, REP, MG)

trit <- with(data,hw(GEN,MG,crop="trit"))

#Extract the average PH per genotype
trit <- with(data,hw(GEN,MG,crop="trit",stat="mean"))
}
\references{
Brasil. Ministerio da Agricultura, Pecuaria e Abastecimento.
Secretaria de Defesa Agropecuaria. Regras para Analise de Sementes.
Brasilia: MAPA/ACS, 2009. 399 p. ISBN 978-85-99851-70-8.
}
\author{
Willyan Junior Adorian Bandeira

Ivan Ricardo Carvalho

Murilo Vieira Loro

Leonardo Cesar Pradebon

Jose Antonio Gonzalez da Silva
}
