% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmm2_utils.R
\name{.pmm2_fit}
\alias{.pmm2_fit}
\title{PMM2 fitting algorithm - unified implementation}
\usage{
.pmm2_fit(
  b_init,
  X,
  y,
  m2,
  m3,
  m4,
  max_iter = 50,
  tol = 1e-06,
  regularize = TRUE,
  reg_lambda = 1e-08,
  verbose = FALSE
)
}
\arguments{
\item{b_init}{initial parameter estimates (typically from OLS)}

\item{X}{design matrix}

\item{y}{response vector}

\item{m2, m3, m4}{central moments}

\item{max_iter}{maximum number of iterations}

\item{tol}{convergence tolerance}

\item{regularize}{logical, add small value to diagonal for numerical stability}

\item{reg_lambda}{regularization parameter (if regularize=TRUE)}

\item{verbose}{logical, whether to print progress information}
}
\value{
A list with components:
\item{b}{estimated parameters}
\item{convergence}{logical convergence status}
\item{iterations}{number of iterations performed}
}
\description{
Core iterative algorithm for PMM2 parameter estimation
}
\keyword{internal}
