% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ETRep_Functions.R
\name{plot_Elliptical_Tube}
\alias{plot_Elliptical_Tube}
\title{Plot an Elliptical Tube (ETRep)}
\usage{
plot_Elliptical_Tube(
  tube,
  plot_boundary = TRUE,
  plot_r_max = FALSE,
  plot_r_project = TRUE,
  plot_frames = TRUE,
  frameScaling = NA,
  plot_spine = TRUE,
  plot_normal_vec = FALSE,
  plot_skeletal_sheet = TRUE,
  decorate = TRUE,
  colSkeletalSheet = "blue",
  colorBoundary = "blue",
  add = FALSE
)
}
\arguments{
\item{tube}{List containing ETRep details.}

\item{plot_boundary}{Logical, enables plotting of the boundary (default is TRUE).}

\item{plot_r_max}{Logical, enables plotting of max projection size (default is FALSE).}

\item{plot_r_project}{Logical, enables plotting of projection along normals (default is TRUE).}

\item{plot_frames}{Logical, enables plotting of the material frames (default is TRUE).}

\item{frameScaling}{Numeric, scale factor for frames.}

\item{plot_spine}{Logical, enables plotting of the spine.}

\item{plot_normal_vec}{Logical, enables plotting of the normals.}

\item{plot_skeletal_sheet}{Logical, enables plotting of the surface skeleton.}

\item{decorate}{Logical, enables decorate the plot}

\item{colSkeletalSheet}{String, defining the color of the surface skeleton}

\item{colorBoundary}{String, defining the color of the e-tube}

\item{add}{Logical, enables overlay plotting}
}
\value{
Graphical output.
}
\description{
Plots a given ETRep with options for boundary, material frames, and projection visualization.
}
\examples{
# Load tube
data("colon3D")
\dontrun{
plot_Elliptical_Tube(tube = colon3D,
                     plot_frames = FALSE)
 }
}
