% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wfdb-structures.R
\name{header_table}
\alias{header_table}
\alias{is_header_table}
\title{Header Table}
\usage{
header_table(
  record_name = character(),
  number_of_channels = integer(),
  frequency = 250,
  samples = integer(),
  start_time = strptime(Sys.time(), "\%Y-\%m-\%d \%H:\%M:\%OSn"),
  ADC_saturation = integer(),
  file_name = character(),
  storage_format = 16L,
  ADC_gain = 200L,
  ADC_baseline = ADC_zero,
  ADC_units = "mV",
  ADC_resolution = 12L,
  ADC_zero = 0L,
  initial_value = ADC_zero,
  checksum = 0L,
  blocksize = 0L,
  label = character(),
  info_strings = list(),
  additional_gain = 1,
  low_pass = integer(),
  high_pass = integer(),
  color = "#000000",
  scale = integer()
)

is_header_table(x)
}
\arguments{
\item{record_name}{A \code{character} vector of record line information}

\item{number_of_channels}{An \code{integer} describing number of signals}

\item{frequency}{A \code{numeric} value of sampling frequency, 250 Hz default}

\item{samples}{An \code{integer} for the number of samples}

\item{start_time}{The \code{POSIXct} time of recording, with miliseconds included.
For example, \code{strptime(start_time, "\%Y-\%m-\%d \%H:\%M\%:\%OSn")} where as
described in \code{\link[base:strptime]{base::strptime()}}}

\item{ADC_saturation}{An \code{integer} representing ADC saturation}

\item{file_name}{A \code{character} for the signal specific information}

\item{storage_format}{An \code{integer} of the bits for the storage format, 16-bit
default}

\item{ADC_gain}{An \code{integer} of ADC gain, default of 200}

\item{ADC_baseline}{An \code{integer} of ADC baseline, defaults to \strong{ADC_zero}}

\item{ADC_units}{A \code{character} to describe ADC units, "mV" is default}

\item{ADC_resolution}{An \code{integer} for ADC resolution, default is 12}

\item{ADC_zero}{An \code{integer} for ADC zero, defaults to 0}

\item{initial_value}{An \code{integer} for the initial value, defaults to
\strong{ADC_zero} value}

\item{checksum}{An \code{integer} that serves as the checksum}

\item{blocksize}{An \code{integer} of the block size}

\item{label}{A \code{character} description of the signal}

\item{info_strings}{A \code{list} of strings that will be written as an appendix
to the header file, usually containing information about the channels,
(e.g. list of colors, extra labels, etc).}

\item{additional_gain}{A \code{numeric} Additional gain, defaults to 1.0}

\item{low_pass}{An \code{integer} Low pass filter}

\item{high_pass}{An \code{integer} High pass filter}

\item{color}{A \code{character} Color as hexadecimal format, defaults to black}

\item{scale}{An \code{integer} Scale}

\item{x}{A \code{data.table} object that serves as the header table}
}
\value{
A \code{header_table} object that is an extension of the \code{data.table}
class. This contains an adaptation of the function arguments, allowing for
compatibility with the WFDB class.
}
\description{
\code{header_table()} modifies the \code{data.table} class to work with
header data. The header data is read in from a similar format as to that of
WFDB files and should be compatible/interchangeable when writing out to disk.
The details extensively cover the type of data that is input. Generally, this
function is called by \verb{read_*_header()} functions and will generally not be
called by the end-user.
}
\details{
The \code{header_table} object is relatively complex in that it directly
deals with properties of the signal, and allows compatibility with WFDB
files and other raw header files for other signal objects. It can be written
out using \code{\link[=write_wfdb]{write_wfdb()}}.
}
\section{Header file structure}{
There are three components to the header file:
\enumerate{
\item \strong{Record line} that contains the following information, in the order
documented, however pieces may be missing based on different parameters.
From left to right...
\itemize{
\item Record name
\item Number of signals: represents number of segments/channels
\item Sampling frequency (optional)
\item Number of samples (optional)
\item Time: in HH:MM:SS format (optional)
\item Date: in DD/MM/YYYY (optional)
}
\item \strong{Signal specification lines} contains specifications for individual
signals, and there must be as many signal lines as there are reported by the
above record line. From left to right....
\itemize{
\item File name: usually *.dat
\item Format \code{integer}: represents storage type, e.g. 8-bit or 16-bit
\item ADC gain: ADC units per physical unit (optional)
\itemize{
\item Baseline: corresponds to 0 physical units, sep = '*(0)" (optional)
\item Units: with '/' as a field separator e.g '*/mV' (optional)
}
\item ADC resolution \code{integer}: bits, usually 8 or 16 (optional)
\item ADC zero: represents middle of ADC input range (optional)
\item Initial value (optional)
\item Checksum (optional)
\item Block size (optional)
\item Description: text or label information (optional)
}
\item \strong{Info strings} are unstructured lines that contains information about
the record. Usually are descriptive. Starts with initial '#' without
preceding white space at beginning of line.
}
}

