\name{sphere}
\alias{sphere}
\title{Sphere Function for Benchmarking Optimization Algorithms}

\usage{
sphere(x)
}

\arguments{
\item{x}{
  A numeric vector representing the input variables for which the Sphere function is evaluated.
  }
}

\value{
Returns a numeric value representing the evaluation of the Sphere function at the given input vector \code{x}.
}

\description{
The Sphere function is one of the simplest and most commonly used benchmark functions in optimization. It is a unimodal, convex function with a single global minimum, making it useful for testing the performance of optimization algorithms, especially in smooth, continuous search spaces.
}

\examples{

# Evaluation 1: Global minimum point in a four-dimensional space
x <- rep(0, 4)
sphere(x)

# Evaluation 2: A point in a six-dimensional space
x <- c(0, 0.24, 11, -1, -0.7, pi)
sphere(x)

# Contour Plot: Visualizing the Sphere Function
x1 <- seq(-10, 10, length.out = 100)
x2 <- seq(-10, 10, length.out = 100)
z <- outer(x1, x2, FUN = Vectorize(function(x, y) sphere(c(x, y))))
contour(x1, x2, z, nlevels = 20, main = "Contour of the Sphere Function")

# EDA.mnorm() example
res = EDA.mnorm(fun = sphere, lower = c(-10,-10), upper = c(10,10), n = 30, 
                k = 2, tolerance = 0.01, maxiter = 200)
res$sol

# Contour plot: Visualizing solution with EDA.mnorm()
x1 <- seq(-10, 10, length.out = 100)
x2 <- seq(-10, 10, length.out = 100)
z <- outer(x1, x2, FUN = Vectorize(function(x, y) sphere(c(x, y))))
contour(x1, x2, z, nlevels = 20, cex.axis = 0.8, 
        main = "Contour plot of the Sphere Function with EDA.mnorm solution")
points(res$sol[1], res$sol[2], col = "red", pch = 19)
}

\references{
De Jong, K. A. (1975). \emph{Analysis of the Behavior of a Class of Genetic Adaptive Systems}. Ph.D. dissertation, University of Michigan.
}
