/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.ibase.toolkit;

import java.awt.Color;
import org.rosuda.ibase.Common;
import org.rosuda.ibase.SMarker;
import org.rosuda.ibase.toolkit.PlotPrimitive;
import org.rosuda.util.Stopwatch;

public abstract class PPrimBase
implements PlotPrimitive {
    public Color col;
    public Color COL_OUTLINE = Color.BLACK;
    public int[] ref;
    protected boolean visible = true;
    protected boolean dragging = false;
    public boolean queryable = true;
    public Color fillColor = Common.objectsColor;
    public Color borderColor = Color.BLACK;
    public Color fillColorSel = Common.selectColor;
    public Color borderColorSel = Common.selectColor;
    public Color fillColorDrag = new Color(128, 128, 128, 70);
    public boolean performAlphaBlending = true;

    public String toString() {
        return "PPrimBase[" + this.cases() + " cases]";
    }

    public int[] getCaseIDs() {
        return this.ref;
    }

    public void setCaseIDs(int[] nArray) {
        this.ref = nArray;
    }

    public void setCaseIDs(double[] dArray) {
        if (dArray == null) {
            return;
        }
        int[] nArray = new int[dArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (int)dArray[i];
        }
        this.ref = nArray;
    }

    public int getPrimaryCase() {
        return this.ref == null || this.ref.length != 1 ? -1 : this.ref[0];
    }

    public boolean representsCase(int n) {
        if (this.ref == null || this.ref.length < 1) {
            return false;
        }
        if (this.ref.length == 1) {
            return this.ref[0] == n;
        }
        int n2 = 0;
        while (n2 < this.ref.length) {
            if (this.ref[n2++] != n) continue;
            return true;
        }
        return false;
    }

    public int cases() {
        return this.ref == null ? 0 : this.ref.length;
    }

    public void setMark(SMarker sMarker, boolean bl) {
        if (this.ref != null) {
            int n = this.ref.length;
            for (int i = 0; i < n; ++i) {
                sMarker.set(this.ref[i], sMarker.at(this.ref[i]) ? bl : true);
            }
        }
    }

    public double getMarkedProportion(SMarker sMarker, int n) {
        return this.getMarkedProportion(sMarker, n, false);
    }

    public double getMarkedProportion(SMarker sMarker, int n, boolean bl) {
        if (this.ref != null && sMarker != null) {
            int n2 = this.ref.length;
            if (n2 == 0) {
                return 0.0;
            }
            int n3 = 0;
            for (int i = 0; i < n2; ++i) {
                if ((n != -1 || sMarker.get(this.ref[i]) != n) && (n <= -1 || sMarker.getSec(this.ref[i]) != n || bl && sMarker.get(this.ref[i]) == -1)) continue;
                ++n3;
            }
            Stopwatch stopwatch = new Stopwatch();
            stopwatch.profile("PlotPrimitive.getMarkedProportion");
            return (double)n3 / (double)n2;
        }
        return 0.0;
    }

    public Color getColor() {
        return this.col;
    }

    int[] roundProportions(double[] dArray, double d, int n) {
        int[] nArray = new int[dArray.length];
        int n2 = -1;
        int n3 = dArray.length;
        while (dArray[++n2] == 0.0) {
        }
        while (dArray[--n3] == 0.0) {
        }
        int n4 = 1;
        double d2 = 0.0;
        int n5 = 0;
        int n6 = 24;
        while (n5 != n && n4 < 64) {
            ++n4;
            n5 = 0;
            for (int i = n2; i <= n3; ++i) {
                if (n4 >= n6) {
                    d2 = Math.random() - 0.5;
                }
                nArray[i] = dArray[i] < 1.0E-10 ? 0 : (int)Math.round(dArray[i] / d * (double)n + d2);
                n5 += nArray[i];
            }
            if (n5 > n) {
                d2 -= 1.0 / Math.pow(2.0, n4);
                continue;
            }
            if (n5 >= n) continue;
            d2 += 1.0 / Math.pow(2.0, n4);
        }
        if (n5 != n) {
            System.out.println(" Rounding Failed !!!");
        }
        return nArray;
    }

    public boolean isQueryable() {
        return this.queryable;
    }

    protected double getRelativeMarkedProportion(SMarker sMarker, int n) {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < this.ref.length; ++i) {
            if (sMarker.getSec(this.ref[i]) != n) continue;
            d += 1.0;
            if (sMarker.get(this.ref[i]) != -1) continue;
            d2 += 1.0;
        }
        return d == 0.0 ? 0.0 : d2 / d;
    }

    protected int getPropSize(int n, double d) {
        int n2 = (int)Math.round((double)n * d);
        if (n2 == 0 && d > 0.0) {
            n2 = 1;
        } else if (n2 == n && d < 1.0) {
            n2 = n - 1;
        }
        return n2;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setDragging(boolean bl) {
        this.dragging = bl;
    }

    public boolean isDragging() {
        return this.dragging;
    }

    public void move(int n, int n2) {
    }

    public void moveX(int n) {
    }

    public void moveY(int n) {
    }

    public boolean hilitcontains(int n, int n2) {
        return false;
    }

    public boolean isPerformingAlphaBlending() {
        return this.performAlphaBlending;
    }
}

