/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.ibase.toolkit;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.ListIterator;
import java.util.TreeMap;
import org.rosuda.ibase.SVar;

public final class FrequencyTable {
    private int vsize;
    private SVar[] vars;
    private CombinationEntry[] ceTable;
    private double[] table;
    private double[] exp;
    private double p;
    private int[] levels;
    private String[][] lnames;

    public FrequencyTable(SVar[] sVarArray) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        this.vars = sVarArray;
        this.vsize = sVarArray.length;
        int n6 = 1;
        for (n5 = 0; n5 < this.vsize; ++n5) {
            n6 *= this.vars[n5].getNumCats();
        }
        this.ceTable = new CombinationEntry[n6];
        this.table = new double[n6];
        this.exp = new double[n6];
        for (n5 = 0; n5 < this.ceTable.length; ++n5) {
            this.ceTable[n5] = new CombinationEntry();
        }
        int[] nArray = new int[this.vsize];
        int n7 = 0;
        while (nArray[0] < this.vars[0].getNumCats()) {
            nArray[this.vsize - 1] = 0;
            while (nArray[this.vsize - 1] < this.vars[this.vsize - 1].getNumCats()) {
                for (n4 = 0; n4 < this.vsize; ++n4) {
                    this.ceTable[n7 + nArray[this.vsize - 1]].addCat(this.vars[n4].getName(), this.vars[n4].getCategories()[this.vars[n4].mainSeq().catAtPos(nArray[n4])]);
                }
                int n8 = this.vsize - 1;
                nArray[n8] = nArray[n8] + 1;
            }
            for (n4 = this.vsize - 2; n4 >= 0; --n4) {
                nArray[n4 + 1] = 0;
                int n9 = n4;
                nArray[n9] = nArray[n9] + 1;
                if (nArray[n9] < this.vars[n4].getNumCats()) break;
            }
            n7 += this.vars[this.vsize - 1].getNumCats();
        }
        for (n4 = 0; n4 < this.ceTable.length; ++n4) {
            this.ceTable[n4].cases = new ArrayList((int)((double)this.vars[0].size() / Math.pow(this.vars[0].getNumCats(), this.vars.length)));
        }
        int[] nArray2 = new int[this.vars.length];
        nArray2[nArray2.length - 1] = 1;
        for (int i = nArray2.length - 2; i >= 0; --i) {
            nArray2[i] = nArray2[i + 1] * this.vars[i + 1].getNumCats();
        }
        TreeMap[] treeMapArray = new TreeMap[this.vars.length];
        for (n3 = 0; n3 < treeMapArray.length; ++n3) {
            treeMapArray[n3] = new TreeMap();
        }
        for (n3 = 0; n3 < this.vars[0].size(); ++n3) {
            Object object;
            int[] nArray3 = new int[this.vars.length];
            for (n2 = this.vars.length - 1; n2 >= 0; --n2) {
                object = this.vars[n2].at(n3).toString();
                Object v = treeMapArray[n2].get(object);
                if (v == null) {
                    nArray3[n2] = -1;
                    for (n = 0; n < this.vars[n2].getNumCats(); ++n) {
                        if (!this.vars[n2].at(n3).toString().equals(this.vars[n2].getCategories()[n].toString())) continue;
                        nArray3[n2] = n;
                        break;
                    }
                    treeMapArray[n2].put(object, new Integer(nArray3[n2]));
                    continue;
                }
                nArray3[n2] = (Integer)v;
            }
            n2 = 0;
            for (int i = 0; i < this.vars.length; ++i) {
                n2 += nArray2[i] * nArray3[i];
            }
            object = this.ceTable[n2];
            ((CombinationEntry)object).cases.add(new Integer(n3));
        }
        for (n3 = 0; n3 < this.ceTable.length; ++n3) {
            this.table[n3] = this.ceTable[n3].cases.size();
        }
        n3 = 0;
        for (int i = 0; i < this.vsize; ++i) {
            if (this.vars[i].getNumCats() <= n3) continue;
            n3 = this.vars[i].getNumCats();
        }
        int[][] nArray4 = new int[this.vsize][n3];
        for (n2 = 0; n2 < this.vsize; ++n2) {
            for (int i = 0; i < this.vars[n2].getNumCats(); ++i) {
                nArray4[n2][i] = 0;
            }
        }
        for (n2 = 0; n2 < this.vsize; ++n2) {
            for (int i = 0; i < this.vars[n2].size(); ++i) {
                int[] nArray5 = nArray4[n2];
                int n10 = this.vars[n2].getCatIndex(i);
                nArray5[n10] = nArray5[n10] + 1;
            }
        }
        double d = Math.pow(this.vars[0].size(), -this.vsize);
        int n11 = 0;
        while (n11 < this.exp.length) {
            this.exp[n11] = 1.0;
            n = n11;
            for (int i = this.vsize - 1; i >= 0; --i) {
                int n12 = n11;
                this.exp[n12] = this.exp[n12] * (double)nArray4[i][n % this.vars[i].getNumCats()];
                n /= this.vars[i].getNumCats();
            }
            int n13 = n11++;
            this.exp[n13] = this.exp[n13] * d;
        }
    }

    public int[] getLevels() {
        if (this.levels == null) {
            this.levels = new int[this.vars.length];
            for (int i = 0; i < this.vars.length; ++i) {
                this.levels[i] = this.vars[i].getNumCats();
            }
        }
        return this.levels;
    }

    public String[][] getLnames() {
        if (this.lnames == null) {
            this.lnames = new String[this.vars.length][];
            for (int i = 0; i < this.vars.length; ++i) {
                this.lnames[i] = new String[this.getLevels()[i]];
                for (int j = 0; j < this.getLevels()[i]; ++j) {
                    this.lnames[i][j] = this.vars[i].getCatAt(this.vars[i].mainSeq().catAtPos(j)).toString();
                }
            }
        }
        return this.lnames;
    }

    public double[] getTable() {
        return this.table;
    }

    public double[] getExp() {
        return this.exp;
    }

    public int[] getMatchingCases(int[] nArray, int n) {
        int n2;
        for (int i = 0; i < nArray.length && i < n; ++i) {
            if (nArray[i] != -1) continue;
            n = i;
            break;
        }
        int[] nArray2 = new int[this.vsize];
        nArray2[this.vsize - 1] = 1;
        for (n2 = this.vsize - 2; n2 >= 0; --n2) {
            nArray2[n2] = nArray2[n2 + 1] * this.vars[n2 + 1].getNumCats();
        }
        n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 += nArray2[i] * nArray[i];
        }
        ArrayList<int[]> arrayList = new ArrayList<int[]>(nArray2[n - 1]);
        int n3 = 0;
        for (int i = 0; i < nArray2[n - 1]; ++i) {
            int[] nArray3 = this.ceTable[n2 + i].getCases();
            arrayList.add(nArray3);
            n3 += nArray3.length;
        }
        int[] nArray4 = new int[n3];
        int n4 = 0;
        ListIterator listIterator = arrayList.listIterator();
        while (listIterator.hasNext()) {
            int[] nArray5 = (int[])listIterator.next();
            System.arraycopy(nArray5, 0, nArray4, n4, nArray5.length);
            n4 += nArray5.length;
        }
        return nArray4;
    }

    public void permute(int[] nArray) {
        int n;
        int n2;
        int n3;
        int[] nArray2 = new int[this.vsize];
        double[] dArray = new double[this.table.length];
        CombinationEntry[] combinationEntryArray = new CombinationEntry[this.table.length];
        double[] dArray2 = new double[this.table.length];
        String[][] stringArrayArray = new String[this.vsize][];
        SVar[] sVarArray = new SVar[this.vsize];
        for (int i = 0; i < this.vsize; ++i) {
            stringArrayArray[i] = new String[this.lnames[nArray[i]].length];
        }
        int[] nArray3 = new int[this.vsize];
        nArray2[this.vsize - 1] = 0;
        nArray2[this.vsize - 2] = this.levels[this.vsize - 1];
        for (int i = this.vsize - 3; i >= 0; --i) {
            nArray2[i] = nArray2[i + 1] * this.levels[i + 1];
        }
        int[][] nArray4 = new int[this.table.length][this.vsize];
        for (n3 = 0; n3 < this.table.length; ++n3) {
            n2 = n3;
            for (n = 0; n < this.vsize - 1; ++n) {
                nArray4[n3][n] = n2 / nArray2[n];
                n2 -= nArray4[n3][n] * nArray2[n];
            }
            nArray4[n3][this.vsize - 1] = n2;
        }
        for (n3 = 0; n3 < this.vsize; ++n3) {
            sVarArray[n3] = this.vars[nArray[n3]];
            nArray3[n3] = this.levels[nArray[n3]];
        }
        for (n3 = 0; n3 < this.vsize; ++n3) {
            for (n = 0; n < stringArrayArray[n3].length; ++n) {
                stringArrayArray[n3][n] = this.lnames[nArray[n3]][n];
            }
        }
        this.levels = nArray3;
        this.lnames = stringArrayArray;
        nArray2[this.vsize - 2] = this.levels[this.vsize - 1];
        for (n3 = this.vsize - 3; n3 >= 0; --n3) {
            nArray2[n3] = nArray2[n3 + 1] * this.levels[n3 + 1];
        }
        for (n3 = 0; n3 < this.table.length; ++n3) {
            n2 = 0;
            for (n = 0; n < this.vsize - 1; ++n) {
                n2 += nArray4[n3][nArray[n]] * nArray2[n];
            }
            dArray[n2 += nArray4[n3][nArray[this.vsize - 1]]] = this.table[n3];
            combinationEntryArray[n2] = this.ceTable[n3];
            dArray2[n2] = this.exp[n3];
        }
        this.table = dArray;
        this.ceTable = combinationEntryArray;
        this.exp = dArray2;
        this.vars = sVarArray;
    }

    public SVar[] getVars() {
        return this.vars;
    }

    public double getP() {
        return this.p;
    }

    private final class CombinationEntry {
        Hashtable ccs = new Hashtable();
        List cases = new ArrayList(0);

        public CombinationEntry() {
        }

        public int[] getCases() {
            int[] nArray = new int[this.cases.size()];
            int n = this.cases.size();
            for (int i = 0; i < nArray.length && i < n; ++i) {
                nArray[i] = (Integer)this.cases.get(i);
            }
            return nArray;
        }

        public int getCombSize() {
            return this.cases.size();
        }

        public Hashtable getCats() {
            return this.ccs;
        }

        public String getCombInfo() {
            String string = "";
            Enumeration enumeration = this.ccs.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                string = string + k + ": " + this.ccs.get(k);
                if (!enumeration.hasMoreElements()) continue;
                string = string + "\n";
            }
            return string;
        }

        public CombinationEntry(CombinationEntry combinationEntry) {
            this.ccs.putAll(combinationEntry.ccs);
        }

        protected void addCat(Object object, Object object2) {
            this.ccs.put(object, object2);
        }

        protected boolean CombinationEqualsCase(int n) {
            for (int i = 0; i < FrequencyTable.this.vsize; ++i) {
                Comparable comparable = (Comparable)this.ccs.get(FrequencyTable.this.vars[i].getName());
                if (comparable.toString().compareTo(FrequencyTable.this.vars[i].at(n).toString()) == 0) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            String string = "";
            Enumeration enumeration = this.ccs.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                string = string + k + ": " + this.ccs.get(k);
                if (!enumeration.hasMoreElements()) continue;
                string = string + ", ";
            }
            return string + " : " + this.cases.size();
        }
    }
}

