/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JGR.robjects;

import java.text.DecimalFormat;
import java.util.Vector;

public class RModel {
    private Double rsquared;
    private Double deviance;
    private Double aic;
    private Integer df = null;
    private String family = null;
    private String call = null;
    private String data = null;
    private final Vector info = new Vector();
    private final DecimalFormat dformat = new DecimalFormat("#0.00");
    private String type = "model";
    private String name;

    public RModel(String string, String string2) {
        this.name = string;
        if (string2 != null) {
            this.type = string2;
        }
    }

    public String getTypeName() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public void setCall(String string) {
        this.call = string;
    }

    public String getCall() {
        return this.call;
    }

    public String getToolTip() {
        return "<html><pre>" + this.call + "</pre></html>";
    }

    public void setRsquared(double d) {
        this.rsquared = new Double(this.dformat.format(d).replace(',', '.'));
    }

    public void setDeviance(double d) {
        this.deviance = new Double(this.dformat.format(d).replace(',', '.'));
    }

    public void setDf(int n) {
        this.df = new Integer(n);
    }

    public void setAic(double d) {
        this.aic = new Double(this.dformat.format(d).replace(',', '.'));
    }

    public void setFamily(String string) {
        this.family = string;
    }

    public String getFamily() {
        return this.family;
    }

    public void setData(String string) {
        this.data = string;
    }

    public String getData() {
        return this.data;
    }

    public Vector getInfo() {
        if (this.info.size() == 0) {
            this.info.add(this.getName());
            this.info.add(this.getData());
            this.info.add(this.getTypeName());
            this.info.add(this.family);
            this.info.add(this.df);
            this.info.add(this.rsquared);
            this.info.add(this.aic);
            this.info.add(this.deviance);
        }
        return this.info;
    }

    public String toString() {
        return this.getName() + " (model)";
    }
}

