% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_saturation.R
\name{set_saturation}
\alias{set_saturation}
\title{Compute and Visualize Code Saturation}
\usage{
set_saturation(
  code_counts,
  total_media_titles = NULL,
  table_min_count = 1,
  table_min_prop = NULL,
  output_type = c("tibble", "kable"),
  plot = FALSE,
  plot_min_count = NULL,
  plot_min_prop = NULL,
  plot_metric = c("prop", "count", "both"),
  fill_color = "steelblue"
)
}
\arguments{
\item{code_counts}{A tibble or data frame containing columns:
\itemize{
\item \code{code}: the code label
\item \code{count}: total number of excerpts coded with that code
\item \code{n_media_titles}: number of distinct media titles (e.g., transcripts) in which the code appears.
This object is typically generated by \code{create_code_summary()}.
}}

\item{total_media_titles}{Optional numeric value indicating the total number of media titles.
If \code{NULL} (default), the function uses the maximum value of \code{n_media_titles}.}

\item{table_min_count}{Minimum count threshold for including a code in the output table.
Defaults to 1.}

\item{table_min_prop}{Minimum proportion threshold (relative to total media titles)
for including a code in the output table. Defaults to \code{NULL} (no proportion filter).}

\item{output_type}{Character string indicating the output format for the table:
either \code{"tibble"} (default) or \code{"kable"}.}

\item{plot}{Logical; if \code{TRUE}, produces a ggplot visualization.
Defaults to \code{FALSE}.}

\item{plot_min_count}{Minimum count threshold for codes to include in the plot.
Defaults to \code{table_min_count} if \code{NULL}.}

\item{plot_min_prop}{Minimum proportion threshold for codes to include in the plot.
Defaults to \code{table_min_prop} if \code{NULL}.}

\item{plot_metric}{Character string indicating what to plot:
\code{"prop"} for proportions, \code{"count"} for counts, or \code{"both"} for dual-axis plot.
Defaults to \code{"prop"}.}

\item{fill_color}{Character string specifying the fill color for bars in the plot.
Defaults to \code{"steelblue"}.}
}
\value{
\itemize{
\item If \code{plot = FALSE}: returns a tibble (or kable table) summarizing code frequencies
and proportions.
\item If \code{plot = TRUE}: returns a list with two elements:
\itemize{
\item \code{table}: the filtered tibble
\item \code{plot}: a ggplot2 object.
}
}
}
\description{
This function summarizes code counts and their proportional representation
across media titles (e.g., interviews, focus groups, or other qualitative data sources).
It can optionally produce a formatted table and/or a ggplot visualization
showing saturation by code frequency or proportion.
}
\examples{
# Example dataset
code_counts <- tibble::tibble(
  code = c("Belonging", "Resilience", "Stress", "Hope"),
  count = c(15, 10, 8, 5),
  n_media_titles = c(8, 6, 5, 3)
)

# Basic usage (returns a tibble)
set_saturation(code_counts)

# Apply count and proportion filters, return a kable table
set_saturation(
  code_counts,
  total_media_titles = 10,
  table_min_count = 5,
  table_min_prop = 0.3,
  output_type = "kable"
)

# Generate a plot of proportions
res <- set_saturation(
  code_counts,
  total_media_titles = 10,
  plot = TRUE,
  plot_metric = "prop"
)
res$plot

# Plot both count and proportion using dual y-axes
res <- set_saturation(
  code_counts,
  total_media_titles = 10,
  plot = TRUE,
  plot_metric = "both",
  fill_color = "darkgreen"
)
res$plot

}
